// NOTE: This file was generated by the ServiceGenerator.

// ----------------------------------------------------------------------------
// API:
//   Drive API (drive/v3)
// Description:
//   Manages files in Drive including uploading, downloading, searching,
//   detecting changes, and updating sharing permissions.
// Documentation:
//   https://developers.google.com/drive/

#if SWIFT_PACKAGE || GTLR_USE_MODULAR_IMPORT
  @import GoogleAPIClientForRESTCore;
#elif GTLR_BUILT_AS_FRAMEWORK
  #import "GTLR/GTLRObject.h"
#else
  #import "GTLRObject.h"
#endif

#if GTLR_RUNTIME_VERSION != 3000
#error This file was generated by a different version of ServiceGenerator which is incompatible with this GTLR library source.
#endif

@class GTLRDrive_About_DriveThemes_Item;
@class GTLRDrive_About_ExportFormats;
@class GTLRDrive_About_ImportFormats;
@class GTLRDrive_About_MaxImportSizes;
@class GTLRDrive_About_StorageQuota;
@class GTLRDrive_About_TeamDriveThemes_Item;
@class GTLRDrive_Change;
@class GTLRDrive_Channel_Params;
@class GTLRDrive_Comment;
@class GTLRDrive_Comment_QuotedFileContent;
@class GTLRDrive_ContentRestriction;
@class GTLRDrive_Drive;
@class GTLRDrive_Drive_BackgroundImageFile;
@class GTLRDrive_Drive_Capabilities;
@class GTLRDrive_Drive_Restrictions;
@class GTLRDrive_File;
@class GTLRDrive_File_AppProperties;
@class GTLRDrive_File_Capabilities;
@class GTLRDrive_File_ContentHints;
@class GTLRDrive_File_ContentHints_Thumbnail;
@class GTLRDrive_File_ExportLinks;
@class GTLRDrive_File_ImageMediaMetadata;
@class GTLRDrive_File_ImageMediaMetadata_Location;
@class GTLRDrive_File_Properties;
@class GTLRDrive_File_ShortcutDetails;
@class GTLRDrive_File_VideoMediaMetadata;
@class GTLRDrive_Permission;
@class GTLRDrive_Permission_PermissionDetails_Item;
@class GTLRDrive_Permission_TeamDrivePermissionDetails_Item;
@class GTLRDrive_Reply;
@class GTLRDrive_Revision;
@class GTLRDrive_Revision_ExportLinks;
@class GTLRDrive_TeamDrive;
@class GTLRDrive_TeamDrive_BackgroundImageFile;
@class GTLRDrive_TeamDrive_Capabilities;
@class GTLRDrive_TeamDrive_Restrictions;
@class GTLRDrive_User;

// Generated comments include content from the discovery document; avoid them
// causing warnings since clang's checks are some what arbitrary.
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdocumentation"

NS_ASSUME_NONNULL_BEGIN

/**
 *  Information about the user, the user's Drive, and system capabilities.
 */
@interface GTLRDrive_About : GTLRObject

/**
 *  Whether the user has installed the requesting app.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *appInstalled;

/**
 *  Whether the user can create shared drives.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canCreateDrives;

/**
 *  Deprecated - use canCreateDrives instead.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canCreateTeamDrives;

/** A list of themes that are supported for shared drives. */
@property(nonatomic, strong, nullable) NSArray<GTLRDrive_About_DriveThemes_Item *> *driveThemes;

/**
 *  A map of source MIME type to possible targets for all supported exports.
 */
@property(nonatomic, strong, nullable) GTLRDrive_About_ExportFormats *exportFormats;

/** The currently supported folder colors as RGB hex strings. */
@property(nonatomic, strong, nullable) NSArray<NSString *> *folderColorPalette;

/**
 *  A map of source MIME type to possible targets for all supported imports.
 */
@property(nonatomic, strong, nullable) GTLRDrive_About_ImportFormats *importFormats;

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#about".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/** A map of maximum import sizes by MIME type, in bytes. */
@property(nonatomic, strong, nullable) GTLRDrive_About_MaxImportSizes *maxImportSizes;

/**
 *  The maximum upload size in bytes.
 *
 *  Uses NSNumber of longLongValue.
 */
@property(nonatomic, strong, nullable) NSNumber *maxUploadSize;

/**
 *  The user's storage quota limits and usage. All fields are measured in bytes.
 */
@property(nonatomic, strong, nullable) GTLRDrive_About_StorageQuota *storageQuota;

/** Deprecated - use driveThemes instead. */
@property(nonatomic, strong, nullable) NSArray<GTLRDrive_About_TeamDriveThemes_Item *> *teamDriveThemes;

/** The authenticated user. */
@property(nonatomic, strong, nullable) GTLRDrive_User *user;

@end


/**
 *  GTLRDrive_About_DriveThemes_Item
 */
@interface GTLRDrive_About_DriveThemes_Item : GTLRObject

/** A link to this theme's background image. */
@property(nonatomic, copy, nullable) NSString *backgroundImageLink;

/** The color of this theme as an RGB hex string. */
@property(nonatomic, copy, nullable) NSString *colorRgb;

/**
 *  The ID of the theme.
 *
 *  identifier property maps to 'id' in JSON (to avoid Objective C's 'id').
 */
@property(nonatomic, copy, nullable) NSString *identifier;

@end


/**
 *  A map of source MIME type to possible targets for all supported exports.
 *
 *  @note This class is documented as having more properties of NSArrays of
 *        NSString. Use @c -additionalJSONKeys and @c
 *        -additionalPropertyForName: to get the list of properties and then
 *        fetch them; or @c -additionalProperties to fetch them all at once.
 */
@interface GTLRDrive_About_ExportFormats : GTLRObject
@end


/**
 *  A map of source MIME type to possible targets for all supported imports.
 *
 *  @note This class is documented as having more properties of NSArrays of
 *        NSString. Use @c -additionalJSONKeys and @c
 *        -additionalPropertyForName: to get the list of properties and then
 *        fetch them; or @c -additionalProperties to fetch them all at once.
 */
@interface GTLRDrive_About_ImportFormats : GTLRObject
@end


/**
 *  A map of maximum import sizes by MIME type, in bytes.
 *
 *  @note This class is documented as having more properties of NSNumber (Uses
 *        NSNumber of longLongValue.). Use @c -additionalJSONKeys and @c
 *        -additionalPropertyForName: to get the list of properties and then
 *        fetch them; or @c -additionalProperties to fetch them all at once.
 */
@interface GTLRDrive_About_MaxImportSizes : GTLRObject
@end


/**
 *  The user's storage quota limits and usage. All fields are measured in bytes.
 */
@interface GTLRDrive_About_StorageQuota : GTLRObject

/**
 *  The usage limit, if applicable. This will not be present if the user has
 *  unlimited storage.
 *
 *  Uses NSNumber of longLongValue.
 */
@property(nonatomic, strong, nullable) NSNumber *limit;

/**
 *  The total usage across all services.
 *
 *  Uses NSNumber of longLongValue.
 */
@property(nonatomic, strong, nullable) NSNumber *usage;

/**
 *  The usage by all files in Google Drive.
 *
 *  Uses NSNumber of longLongValue.
 */
@property(nonatomic, strong, nullable) NSNumber *usageInDrive;

/**
 *  The usage by trashed files in Google Drive.
 *
 *  Uses NSNumber of longLongValue.
 */
@property(nonatomic, strong, nullable) NSNumber *usageInDriveTrash;

@end


/**
 *  GTLRDrive_About_TeamDriveThemes_Item
 */
@interface GTLRDrive_About_TeamDriveThemes_Item : GTLRObject

/** Deprecated - use driveThemes/backgroundImageLink instead. */
@property(nonatomic, copy, nullable) NSString *backgroundImageLink;

/** Deprecated - use driveThemes/colorRgb instead. */
@property(nonatomic, copy, nullable) NSString *colorRgb;

/**
 *  Deprecated - use driveThemes/id instead.
 *
 *  identifier property maps to 'id' in JSON (to avoid Objective C's 'id').
 */
@property(nonatomic, copy, nullable) NSString *identifier;

@end


/**
 *  A change to a file or shared drive.
 */
@interface GTLRDrive_Change : GTLRObject

/** The type of the change. Possible values are file and drive. */
@property(nonatomic, copy, nullable) NSString *changeType;

/**
 *  The updated state of the shared drive. Present if the changeType is drive,
 *  the user is still a member of the shared drive, and the shared drive has not
 *  been deleted.
 */
@property(nonatomic, strong, nullable) GTLRDrive_Drive *drive;

/** The ID of the shared drive associated with this change. */
@property(nonatomic, copy, nullable) NSString *driveId;

/**
 *  The updated state of the file. Present if the type is file and the file has
 *  not been removed from this list of changes.
 */
@property(nonatomic, strong, nullable) GTLRDrive_File *file;

/** The ID of the file which has changed. */
@property(nonatomic, copy, nullable) NSString *fileId;

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#change".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/**
 *  Whether the file or shared drive has been removed from this list of changes,
 *  for example by deletion or loss of access.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *removed;

/** Deprecated - use drive instead. */
@property(nonatomic, strong, nullable) GTLRDrive_TeamDrive *teamDrive;

/** Deprecated - use driveId instead. */
@property(nonatomic, copy, nullable) NSString *teamDriveId;

/** The time of this change (RFC 3339 date-time). */
@property(nonatomic, strong, nullable) GTLRDateTime *time;

/** Deprecated - use changeType instead. */
@property(nonatomic, copy, nullable) NSString *type;

@end


/**
 *  A list of changes for a user.
 *
 *  @note This class supports NSFastEnumeration and indexed subscripting over
 *        its "changes" property. If returned as the result of a query, it
 *        should support automatic pagination (when @c shouldFetchNextPages is
 *        enabled).
 */
@interface GTLRDrive_ChangeList : GTLRCollectionObject

/**
 *  The list of changes. If nextPageToken is populated, then this list may be
 *  incomplete and an additional page of results should be fetched.
 *
 *  @note This property is used to support NSFastEnumeration and indexed
 *        subscripting on this class.
 */
@property(nonatomic, strong, nullable) NSArray<GTLRDrive_Change *> *changes;

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#changeList".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/**
 *  The starting page token for future changes. This will be present only if the
 *  end of the current changes list has been reached.
 */
@property(nonatomic, copy, nullable) NSString *newStartPageToken NS_RETURNS_NOT_RETAINED;

/**
 *  The page token for the next page of changes. This will be absent if the end
 *  of the changes list has been reached. If the token is rejected for any
 *  reason, it should be discarded, and pagination should be restarted from the
 *  first page of results.
 */
@property(nonatomic, copy, nullable) NSString *nextPageToken;

@end


/**
 *  An notification channel used to watch for resource changes.
 */
@interface GTLRDrive_Channel : GTLRObject

/** The address where notifications are delivered for this channel. */
@property(nonatomic, copy, nullable) NSString *address;

/**
 *  Date and time of notification channel expiration, expressed as a Unix
 *  timestamp, in milliseconds. Optional.
 *
 *  Uses NSNumber of longLongValue.
 */
@property(nonatomic, strong, nullable) NSNumber *expiration;

/**
 *  A UUID or similar unique string that identifies this channel.
 *
 *  identifier property maps to 'id' in JSON (to avoid Objective C's 'id').
 */
@property(nonatomic, copy, nullable) NSString *identifier;

/**
 *  Identifies this as a notification channel used to watch for changes to a
 *  resource, which is "api#channel".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/** Additional parameters controlling delivery channel behavior. Optional. */
@property(nonatomic, strong, nullable) GTLRDrive_Channel_Params *params;

/**
 *  A Boolean value to indicate whether payload is wanted. Optional.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *payload;

/**
 *  An opaque ID that identifies the resource being watched on this channel.
 *  Stable across different API versions.
 */
@property(nonatomic, copy, nullable) NSString *resourceId;

/** A version-specific identifier for the watched resource. */
@property(nonatomic, copy, nullable) NSString *resourceUri;

/**
 *  An arbitrary string delivered to the target address with each notification
 *  delivered over this channel. Optional.
 */
@property(nonatomic, copy, nullable) NSString *token;

/**
 *  The type of delivery mechanism used for this channel. Valid values are
 *  "web_hook" (or "webhook"). Both values refer to a channel where Http
 *  requests are used to deliver messages.
 */
@property(nonatomic, copy, nullable) NSString *type;

@end


/**
 *  Additional parameters controlling delivery channel behavior. Optional.
 *
 *  @note This class is documented as having more properties of NSString. Use @c
 *        -additionalJSONKeys and @c -additionalPropertyForName: to get the list
 *        of properties and then fetch them; or @c -additionalProperties to
 *        fetch them all at once.
 */
@interface GTLRDrive_Channel_Params : GTLRObject
@end


/**
 *  A comment on a file.
 */
@interface GTLRDrive_Comment : GTLRObject

/**
 *  A region of the document represented as a JSON string. See anchor
 *  documentation for details on how to define and interpret anchor properties.
 */
@property(nonatomic, copy, nullable) NSString *anchor;

/**
 *  The author of the comment. The author's email address and permission ID will
 *  not be populated.
 */
@property(nonatomic, strong, nullable) GTLRDrive_User *author;

/**
 *  The plain text content of the comment. This field is used for setting the
 *  content, while htmlContent should be displayed.
 */
@property(nonatomic, copy, nullable) NSString *content;

/** The time at which the comment was created (RFC 3339 date-time). */
@property(nonatomic, strong, nullable) GTLRDateTime *createdTime;

/**
 *  Whether the comment has been deleted. A deleted comment has no content.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *deleted;

/** The content of the comment with HTML formatting. */
@property(nonatomic, copy, nullable) NSString *htmlContent;

/**
 *  The ID of the comment.
 *
 *  identifier property maps to 'id' in JSON (to avoid Objective C's 'id').
 */
@property(nonatomic, copy, nullable) NSString *identifier;

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#comment".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/**
 *  The last time the comment or any of its replies was modified (RFC 3339
 *  date-time).
 */
@property(nonatomic, strong, nullable) GTLRDateTime *modifiedTime;

/**
 *  The file content to which the comment refers, typically within the anchor
 *  region. For a text file, for example, this would be the text at the location
 *  of the comment.
 */
@property(nonatomic, strong, nullable) GTLRDrive_Comment_QuotedFileContent *quotedFileContent;

/** The full list of replies to the comment in chronological order. */
@property(nonatomic, strong, nullable) NSArray<GTLRDrive_Reply *> *replies;

/**
 *  Whether the comment has been resolved by one of its replies.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *resolved;

@end


/**
 *  The file content to which the comment refers, typically within the anchor
 *  region. For a text file, for example, this would be the text at the location
 *  of the comment.
 */
@interface GTLRDrive_Comment_QuotedFileContent : GTLRObject

/** The MIME type of the quoted content. */
@property(nonatomic, copy, nullable) NSString *mimeType;

/**
 *  The quoted content itself. This is interpreted as plain text if set through
 *  the API.
 */
@property(nonatomic, copy, nullable) NSString *value;

@end


/**
 *  A list of comments on a file.
 *
 *  @note This class supports NSFastEnumeration and indexed subscripting over
 *        its "comments" property. If returned as the result of a query, it
 *        should support automatic pagination (when @c shouldFetchNextPages is
 *        enabled).
 */
@interface GTLRDrive_CommentList : GTLRCollectionObject

/**
 *  The list of comments. If nextPageToken is populated, then this list may be
 *  incomplete and an additional page of results should be fetched.
 *
 *  @note This property is used to support NSFastEnumeration and indexed
 *        subscripting on this class.
 */
@property(nonatomic, strong, nullable) NSArray<GTLRDrive_Comment *> *comments;

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#commentList".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/**
 *  The page token for the next page of comments. This will be absent if the end
 *  of the comments list has been reached. If the token is rejected for any
 *  reason, it should be discarded, and pagination should be restarted from the
 *  first page of results.
 */
@property(nonatomic, copy, nullable) NSString *nextPageToken;

@end


/**
 *  A restriction for accessing the content of the file.
 */
@interface GTLRDrive_ContentRestriction : GTLRObject

/**
 *  Whether the content of the file is read-only. If a file is read-only, a new
 *  revision of the file may not be added, comments may not be added or
 *  modified, and the title of the file may not be modified.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *readOnly;

/**
 *  Reason for why the content of the file is restricted. This is only mutable
 *  on requests that also set readOnly=true.
 */
@property(nonatomic, copy, nullable) NSString *reason;

/**
 *  The user who set the content restriction. Only populated if readOnly is
 *  true.
 */
@property(nonatomic, strong, nullable) GTLRDrive_User *restrictingUser;

/**
 *  The time at which the content restriction was set (formatted RFC 3339
 *  timestamp). Only populated if readOnly is true.
 */
@property(nonatomic, strong, nullable) GTLRDateTime *restrictionTime;

/**
 *  The type of the content restriction. Currently the only possible value is
 *  globalContentRestriction.
 */
@property(nonatomic, copy, nullable) NSString *type;

@end


/**
 *  Representation of a shared drive.
 */
@interface GTLRDrive_Drive : GTLRObject

/**
 *  An image file and cropping parameters from which a background image for this
 *  shared drive is set. This is a write only field; it can only be set on
 *  drive.drives.update requests that don't set themeId. When specified, all
 *  fields of the backgroundImageFile must be set.
 */
@property(nonatomic, strong, nullable) GTLRDrive_Drive_BackgroundImageFile *backgroundImageFile;

/** A short-lived link to this shared drive's background image. */
@property(nonatomic, copy, nullable) NSString *backgroundImageLink;

/** Capabilities the current user has on this shared drive. */
@property(nonatomic, strong, nullable) GTLRDrive_Drive_Capabilities *capabilities;

/**
 *  The color of this shared drive as an RGB hex string. It can only be set on a
 *  drive.drives.update request that does not set themeId.
 */
@property(nonatomic, copy, nullable) NSString *colorRgb;

/** The time at which the shared drive was created (RFC 3339 date-time). */
@property(nonatomic, strong, nullable) GTLRDateTime *createdTime;

/**
 *  Whether the shared drive is hidden from default view.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *hidden;

/**
 *  The ID of this shared drive which is also the ID of the top level folder of
 *  this shared drive.
 *
 *  identifier property maps to 'id' in JSON (to avoid Objective C's 'id').
 */
@property(nonatomic, copy, nullable) NSString *identifier;

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#drive".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/** The name of this shared drive. */
@property(nonatomic, copy, nullable) NSString *name;

/**
 *  A set of restrictions that apply to this shared drive or items inside this
 *  shared drive.
 */
@property(nonatomic, strong, nullable) GTLRDrive_Drive_Restrictions *restrictions;

/**
 *  The ID of the theme from which the background image and color will be set.
 *  The set of possible driveThemes can be retrieved from a drive.about.get
 *  response. When not specified on a drive.drives.create request, a random
 *  theme is chosen from which the background image and color are set. This is a
 *  write-only field; it can only be set on requests that don't set colorRgb or
 *  backgroundImageFile.
 */
@property(nonatomic, copy, nullable) NSString *themeId;

@end


/**
 *  An image file and cropping parameters from which a background image for this
 *  shared drive is set. This is a write only field; it can only be set on
 *  drive.drives.update requests that don't set themeId. When specified, all
 *  fields of the backgroundImageFile must be set.
 */
@interface GTLRDrive_Drive_BackgroundImageFile : GTLRObject

/**
 *  The ID of an image file in Google Drive to use for the background image.
 *
 *  identifier property maps to 'id' in JSON (to avoid Objective C's 'id').
 */
@property(nonatomic, copy, nullable) NSString *identifier;

/**
 *  The width of the cropped image in the closed range of 0 to 1. This value
 *  represents the width of the cropped image divided by the width of the entire
 *  image. The height is computed by applying a width to height aspect ratio of
 *  80 to 9. The resulting image must be at least 1280 pixels wide and 144
 *  pixels high.
 *
 *  Uses NSNumber of floatValue.
 */
@property(nonatomic, strong, nullable) NSNumber *width;

/**
 *  The X coordinate of the upper left corner of the cropping area in the
 *  background image. This is a value in the closed range of 0 to 1. This value
 *  represents the horizontal distance from the left side of the entire image to
 *  the left side of the cropping area divided by the width of the entire image.
 *
 *  Uses NSNumber of floatValue.
 */
@property(nonatomic, strong, nullable) NSNumber *xCoordinate;

/**
 *  The Y coordinate of the upper left corner of the cropping area in the
 *  background image. This is a value in the closed range of 0 to 1. This value
 *  represents the vertical distance from the top side of the entire image to
 *  the top side of the cropping area divided by the height of the entire image.
 *
 *  Uses NSNumber of floatValue.
 */
@property(nonatomic, strong, nullable) NSNumber *yCoordinate;

@end


/**
 *  Capabilities the current user has on this shared drive.
 */
@interface GTLRDrive_Drive_Capabilities : GTLRObject

/**
 *  Whether the current user can add children to folders in this shared drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canAddChildren;

/**
 *  Whether the current user can change the copyRequiresWriterPermission
 *  restriction of this shared drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canChangeCopyRequiresWriterPermissionRestriction;

/**
 *  Whether the current user can change the domainUsersOnly restriction of this
 *  shared drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canChangeDomainUsersOnlyRestriction;

/**
 *  Whether the current user can change the background of this shared drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canChangeDriveBackground;

/**
 *  Whether the current user can change the driveMembersOnly restriction of this
 *  shared drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canChangeDriveMembersOnlyRestriction;

/**
 *  Whether the current user can comment on files in this shared drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canComment;

/**
 *  Whether the current user can copy files in this shared drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canCopy;

/**
 *  Whether the current user can delete children from folders in this shared
 *  drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canDeleteChildren;

/**
 *  Whether the current user can delete this shared drive. Attempting to delete
 *  the shared drive may still fail if there are untrashed items inside the
 *  shared drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canDeleteDrive;

/**
 *  Whether the current user can download files in this shared drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canDownload;

/**
 *  Whether the current user can edit files in this shared drive
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canEdit;

/**
 *  Whether the current user can list the children of folders in this shared
 *  drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canListChildren;

/**
 *  Whether the current user can add members to this shared drive or remove them
 *  or change their role.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canManageMembers;

/**
 *  Whether the current user can read the revisions resource of files in this
 *  shared drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canReadRevisions;

/**
 *  Whether the current user can rename files or folders in this shared drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canRename;

/**
 *  Whether the current user can rename this shared drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canRenameDrive;

/**
 *  Whether the current user can share files or folders in this shared drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canShare;

/**
 *  Whether the current user can trash children from folders in this shared
 *  drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canTrashChildren;

@end


/**
 *  A set of restrictions that apply to this shared drive or items inside this
 *  shared drive.
 */
@interface GTLRDrive_Drive_Restrictions : GTLRObject

/**
 *  Whether administrative privileges on this shared drive are required to
 *  modify restrictions.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *adminManagedRestrictions;

/**
 *  Whether the options to copy, print, or download files inside this shared
 *  drive, should be disabled for readers and commenters. When this restriction
 *  is set to true, it will override the similarly named field to true for any
 *  file inside this shared drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *copyRequiresWriterPermission NS_RETURNS_NOT_RETAINED;

/**
 *  Whether access to this shared drive and items inside this shared drive is
 *  restricted to users of the domain to which this shared drive belongs. This
 *  restriction may be overridden by other sharing policies controlled outside
 *  of this shared drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *domainUsersOnly;

/**
 *  Whether access to items inside this shared drive is restricted to its
 *  members.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *driveMembersOnly;

@end


/**
 *  A list of shared drives.
 *
 *  @note This class supports NSFastEnumeration and indexed subscripting over
 *        its "drives" property. If returned as the result of a query, it should
 *        support automatic pagination (when @c shouldFetchNextPages is
 *        enabled).
 */
@interface GTLRDrive_DriveList : GTLRCollectionObject

/**
 *  The list of shared drives. If nextPageToken is populated, then this list may
 *  be incomplete and an additional page of results should be fetched.
 *
 *  @note This property is used to support NSFastEnumeration and indexed
 *        subscripting on this class.
 */
@property(nonatomic, strong, nullable) NSArray<GTLRDrive_Drive *> *drives;

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#driveList".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/**
 *  The page token for the next page of shared drives. This will be absent if
 *  the end of the list has been reached. If the token is rejected for any
 *  reason, it should be discarded, and pagination should be restarted from the
 *  first page of results.
 */
@property(nonatomic, copy, nullable) NSString *nextPageToken;

@end


/**
 *  The metadata for a file.
 */
@interface GTLRDrive_File : GTLRObject

/**
 *  A collection of arbitrary key-value pairs which are private to the
 *  requesting app.
 *  Entries with null values are cleared in update and copy requests. These
 *  properties can only be retrieved using an authenticated request. An
 *  authenticated request uses an access token obtained with a OAuth 2 client
 *  ID. You cannot use an API key to retrieve private properties.
 */
@property(nonatomic, strong, nullable) GTLRDrive_File_AppProperties *appProperties;

/**
 *  Capabilities the current user has on this file. Each capability corresponds
 *  to a fine-grained action that a user may take.
 */
@property(nonatomic, strong, nullable) GTLRDrive_File_Capabilities *capabilities;

/**
 *  Additional information about the content of the file. These fields are never
 *  populated in responses.
 */
@property(nonatomic, strong, nullable) GTLRDrive_File_ContentHints *contentHints;

/**
 *  Restrictions for accessing the content of the file. Only populated if such a
 *  restriction exists.
 */
@property(nonatomic, strong, nullable) NSArray<GTLRDrive_ContentRestriction *> *contentRestrictions;

/**
 *  Whether the options to copy, print, or download this file, should be
 *  disabled for readers and commenters.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *copyRequiresWriterPermission NS_RETURNS_NOT_RETAINED;

/** The time at which the file was created (RFC 3339 date-time). */
@property(nonatomic, strong, nullable) GTLRDateTime *createdTime;

/**
 *  A short description of the file.
 *
 *  Remapped to 'descriptionProperty' to avoid NSObject's 'description'.
 */
@property(nonatomic, copy, nullable) NSString *descriptionProperty;

/**
 *  ID of the shared drive the file resides in. Only populated for items in
 *  shared drives.
 */
@property(nonatomic, copy, nullable) NSString *driveId;

/**
 *  Whether the file has been explicitly trashed, as opposed to recursively
 *  trashed from a parent folder.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *explicitlyTrashed;

/** Links for exporting Docs Editors files to specific formats. */
@property(nonatomic, strong, nullable) GTLRDrive_File_ExportLinks *exportLinks;

/**
 *  The final component of fullFileExtension. This is only available for files
 *  with binary content in Google Drive.
 */
@property(nonatomic, copy, nullable) NSString *fileExtension;

/**
 *  The color for a folder as an RGB hex string. The supported colors are
 *  published in the folderColorPalette field of the About resource.
 *  If an unsupported color is specified, the closest color in the palette will
 *  be used instead.
 */
@property(nonatomic, copy, nullable) NSString *folderColorRgb;

/**
 *  The full file extension extracted from the name field. May contain multiple
 *  concatenated extensions, such as "tar.gz". This is only available for files
 *  with binary content in Google Drive.
 *  This is automatically updated when the name field changes, however it is not
 *  cleared if the new name does not contain a valid extension.
 */
@property(nonatomic, copy, nullable) NSString *fullFileExtension;

/**
 *  Whether there are permissions directly on this file. This field is only
 *  populated for items in shared drives.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *hasAugmentedPermissions;

/**
 *  Whether this file has a thumbnail. This does not indicate whether the
 *  requesting app has access to the thumbnail. To check access, look for the
 *  presence of the thumbnailLink field.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *hasThumbnail;

/**
 *  The ID of the file's head revision. This is currently only available for
 *  files with binary content in Google Drive.
 */
@property(nonatomic, copy, nullable) NSString *headRevisionId;

/** A static, unauthenticated link to the file's icon. */
@property(nonatomic, copy, nullable) NSString *iconLink;

/**
 *  The ID of the file.
 *
 *  identifier property maps to 'id' in JSON (to avoid Objective C's 'id').
 */
@property(nonatomic, copy, nullable) NSString *identifier;

/** Additional metadata about image media, if available. */
@property(nonatomic, strong, nullable) GTLRDrive_File_ImageMediaMetadata *imageMediaMetadata;

/**
 *  Whether the file was created or opened by the requesting app.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *isAppAuthorized;

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#file".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/** The last user to modify the file. */
@property(nonatomic, strong, nullable) GTLRDrive_User *lastModifyingUser;

/**
 *  The MD5 checksum for the content of the file. This is only applicable to
 *  files with binary content in Google Drive.
 */
@property(nonatomic, copy, nullable) NSString *md5Checksum;

/**
 *  The MIME type of the file.
 *  Google Drive will attempt to automatically detect an appropriate value from
 *  uploaded content if no value is provided. The value cannot be changed unless
 *  a new revision is uploaded.
 *  If a file is created with a Google Doc MIME type, the uploaded content will
 *  be imported if possible. The supported import formats are published in the
 *  About resource.
 */
@property(nonatomic, copy, nullable) NSString *mimeType;

/**
 *  Whether the file has been modified by this user.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *modifiedByMe;

/** The last time the file was modified by the user (RFC 3339 date-time). */
@property(nonatomic, strong, nullable) GTLRDateTime *modifiedByMeTime;

/**
 *  The last time the file was modified by anyone (RFC 3339 date-time).
 *  Note that setting modifiedTime will also update modifiedByMeTime for the
 *  user.
 */
@property(nonatomic, strong, nullable) GTLRDateTime *modifiedTime;

/**
 *  The name of the file. This is not necessarily unique within a folder. Note
 *  that for immutable items such as the top level folders of shared drives, My
 *  Drive root folder, and Application Data folder the name is constant.
 */
@property(nonatomic, copy, nullable) NSString *name;

/**
 *  The original filename of the uploaded content if available, or else the
 *  original value of the name field. This is only available for files with
 *  binary content in Google Drive.
 */
@property(nonatomic, copy, nullable) NSString *originalFilename;

/**
 *  Whether the user owns the file. Not populated for items in shared drives.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *ownedByMe;

/**
 *  The owners of the file. Currently, only certain legacy files may have more
 *  than one owner. Not populated for items in shared drives.
 */
@property(nonatomic, strong, nullable) NSArray<GTLRDrive_User *> *owners;

/**
 *  The IDs of the parent folders which contain the file.
 *  If not specified as part of a create request, the file will be placed
 *  directly in the user's My Drive folder. If not specified as part of a copy
 *  request, the file will inherit any discoverable parents of the source file.
 *  Update requests must use the addParents and removeParents parameters to
 *  modify the parents list.
 */
@property(nonatomic, strong, nullable) NSArray<NSString *> *parents;

/** List of permission IDs for users with access to this file. */
@property(nonatomic, strong, nullable) NSArray<NSString *> *permissionIds;

/**
 *  The full list of permissions for the file. This is only available if the
 *  requesting user can share the file. Not populated for items in shared
 *  drives.
 */
@property(nonatomic, strong, nullable) NSArray<GTLRDrive_Permission *> *permissions;

/**
 *  A collection of arbitrary key-value pairs which are visible to all apps.
 *  Entries with null values are cleared in update and copy requests.
 */
@property(nonatomic, strong, nullable) GTLRDrive_File_Properties *properties;

/**
 *  The number of storage quota bytes used by the file. This includes the head
 *  revision as well as previous revisions with keepForever enabled.
 *
 *  Uses NSNumber of longLongValue.
 */
@property(nonatomic, strong, nullable) NSNumber *quotaBytesUsed;

/**
 *  Whether the file has been shared. Not populated for items in shared drives.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *shared;

/**
 *  The time at which the file was shared with the user, if applicable (RFC 3339
 *  date-time).
 */
@property(nonatomic, strong, nullable) GTLRDateTime *sharedWithMeTime;

/** The user who shared the file with the requesting user, if applicable. */
@property(nonatomic, strong, nullable) GTLRDrive_User *sharingUser;

/**
 *  Shortcut file details. Only populated for shortcut files, which have the
 *  mimeType field set to application/vnd.google-apps.shortcut.
 */
@property(nonatomic, strong, nullable) GTLRDrive_File_ShortcutDetails *shortcutDetails;

/**
 *  The size of the file's content in bytes. This is applicable to binary files
 *  in Google Drive and Google Docs files.
 *
 *  Uses NSNumber of longLongValue.
 */
@property(nonatomic, strong, nullable) NSNumber *size;

/**
 *  The list of spaces which contain the file. The currently supported values
 *  are 'drive', 'appDataFolder' and 'photos'.
 */
@property(nonatomic, strong, nullable) NSArray<NSString *> *spaces;

/**
 *  Whether the user has starred the file.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *starred;

/** Deprecated - use driveId instead. */
@property(nonatomic, copy, nullable) NSString *teamDriveId;

/**
 *  A short-lived link to the file's thumbnail, if available. Typically lasts on
 *  the order of hours. Only populated when the requesting app can access the
 *  file's content. If the file isn't shared publicly, the URL returned in
 *  Files.thumbnailLink must be fetched using a credentialed request.
 */
@property(nonatomic, copy, nullable) NSString *thumbnailLink;

/**
 *  The thumbnail version for use in thumbnail cache invalidation.
 *
 *  Uses NSNumber of longLongValue.
 */
@property(nonatomic, strong, nullable) NSNumber *thumbnailVersion;

/**
 *  Whether the file has been trashed, either explicitly or from a trashed
 *  parent folder. Only the owner may trash a file. The trashed item is excluded
 *  from all files.list responses returned for any user who does not own the
 *  file. However, all users with access to the file can see the trashed item
 *  metadata in an API response. All users with access can copy, download,
 *  export, and share the file.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *trashed;

/**
 *  The time that the item was trashed (RFC 3339 date-time). Only populated for
 *  items in shared drives.
 */
@property(nonatomic, strong, nullable) GTLRDateTime *trashedTime;

/**
 *  If the file has been explicitly trashed, the user who trashed it. Only
 *  populated for items in shared drives.
 */
@property(nonatomic, strong, nullable) GTLRDrive_User *trashingUser;

/**
 *  A monotonically increasing version number for the file. This reflects every
 *  change made to the file on the server, even those not visible to the user.
 *
 *  Uses NSNumber of longLongValue.
 */
@property(nonatomic, strong, nullable) NSNumber *version;

/**
 *  Additional metadata about video media. This may not be available immediately
 *  upon upload.
 */
@property(nonatomic, strong, nullable) GTLRDrive_File_VideoMediaMetadata *videoMediaMetadata;

/**
 *  Whether the file has been viewed by this user.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *viewedByMe;

/** The last time the file was viewed by the user (RFC 3339 date-time). */
@property(nonatomic, strong, nullable) GTLRDateTime *viewedByMeTime;

/**
 *  Deprecated - use copyRequiresWriterPermission instead.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *viewersCanCopyContent;

/**
 *  A link for downloading the content of the file in a browser. This is only
 *  available for files with binary content in Google Drive.
 */
@property(nonatomic, copy, nullable) NSString *webContentLink;

/**
 *  A link for opening the file in a relevant Google editor or viewer in a
 *  browser.
 */
@property(nonatomic, copy, nullable) NSString *webViewLink;

/**
 *  Whether users with only writer permission can modify the file's permissions.
 *  Not populated for items in shared drives.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *writersCanShare;

@end


/**
 *  A collection of arbitrary key-value pairs which are private to the
 *  requesting app.
 *  Entries with null values are cleared in update and copy requests. These
 *  properties can only be retrieved using an authenticated request. An
 *  authenticated request uses an access token obtained with a OAuth 2 client
 *  ID. You cannot use an API key to retrieve private properties.
 *
 *  @note This class is documented as having more properties of NSString. Use @c
 *        -additionalJSONKeys and @c -additionalPropertyForName: to get the list
 *        of properties and then fetch them; or @c -additionalProperties to
 *        fetch them all at once.
 */
@interface GTLRDrive_File_AppProperties : GTLRObject
@end


/**
 *  Capabilities the current user has on this file. Each capability corresponds
 *  to a fine-grained action that a user may take.
 */
@interface GTLRDrive_File_Capabilities : GTLRObject

/**
 *  Whether the current user can add children to this folder. This is always
 *  false when the item is not a folder.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canAddChildren;

/**
 *  Whether the current user can add a folder from another drive (different
 *  shared drive or My Drive) to this folder. This is false when the item is not
 *  a folder. Only populated for items in shared drives.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canAddFolderFromAnotherDrive;

/**
 *  Whether the current user can add a parent for the item without removing an
 *  existing parent in the same request. Not populated for shared drive files.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canAddMyDriveParent;

/**
 *  Whether the current user can change the copyRequiresWriterPermission
 *  restriction of this file.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canChangeCopyRequiresWriterPermission;

/**
 *  Deprecated
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canChangeViewersCanCopyContent;

/**
 *  Whether the current user can comment on this file.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canComment;

/**
 *  Whether the current user can copy this file. For an item in a shared drive,
 *  whether the current user can copy non-folder descendants of this item, or
 *  this item itself if it is not a folder.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canCopy;

/**
 *  Whether the current user can delete this file.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canDelete;

/**
 *  Whether the current user can delete children of this folder. This is false
 *  when the item is not a folder. Only populated for items in shared drives.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canDeleteChildren;

/**
 *  Whether the current user can download this file.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canDownload;

/**
 *  Whether the current user can edit this file. Other factors may limit the
 *  type of changes a user can make to a file. For example, see
 *  canChangeCopyRequiresWriterPermission or canModifyContent.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canEdit;

/**
 *  Whether the current user can list the children of this folder. This is
 *  always false when the item is not a folder.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canListChildren;

/**
 *  Whether the current user can modify the content of this file.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canModifyContent;

/**
 *  Whether the current user can modify restrictions on content of this file.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canModifyContentRestriction;

/**
 *  Whether the current user can move children of this folder outside of the
 *  shared drive. This is false when the item is not a folder. Only populated
 *  for items in shared drives.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canMoveChildrenOutOfDrive;

/**
 *  Deprecated - use canMoveChildrenOutOfDrive instead.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canMoveChildrenOutOfTeamDrive;

/**
 *  Whether the current user can move children of this folder within this drive.
 *  This is false when the item is not a folder. Note that a request to move the
 *  child may still fail depending on the current user's access to the child and
 *  to the destination folder.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canMoveChildrenWithinDrive;

/**
 *  Deprecated - use canMoveChildrenWithinDrive instead.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canMoveChildrenWithinTeamDrive;

/**
 *  Deprecated - use canMoveItemOutOfDrive instead.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canMoveItemIntoTeamDrive;

/**
 *  Whether the current user can move this item outside of this drive by
 *  changing its parent. Note that a request to change the parent of the item
 *  may still fail depending on the new parent that is being added.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canMoveItemOutOfDrive;

/**
 *  Deprecated - use canMoveItemOutOfDrive instead.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canMoveItemOutOfTeamDrive;

/**
 *  Whether the current user can move this item within this drive. Note that a
 *  request to change the parent of the item may still fail depending on the new
 *  parent that is being added and the parent that is being removed.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canMoveItemWithinDrive;

/**
 *  Deprecated - use canMoveItemWithinDrive instead.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canMoveItemWithinTeamDrive;

/**
 *  Deprecated - use canMoveItemWithinDrive or canMoveItemOutOfDrive instead.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canMoveTeamDriveItem;

/**
 *  Whether the current user can read the shared drive to which this file
 *  belongs. Only populated for items in shared drives.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canReadDrive;

/**
 *  Whether the current user can read the revisions resource of this file. For a
 *  shared drive item, whether revisions of non-folder descendants of this item,
 *  or this item itself if it is not a folder, can be read.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canReadRevisions;

/**
 *  Deprecated - use canReadDrive instead.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canReadTeamDrive;

/**
 *  Whether the current user can remove children from this folder. This is
 *  always false when the item is not a folder. For a folder in a shared drive,
 *  use canDeleteChildren or canTrashChildren instead.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canRemoveChildren;

/**
 *  Whether the current user can remove a parent from the item without adding
 *  another parent in the same request. Not populated for shared drive files.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canRemoveMyDriveParent;

/**
 *  Whether the current user can rename this file.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canRename;

/**
 *  Whether the current user can modify the sharing settings for this file.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canShare;

/**
 *  Whether the current user can move this file to trash.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canTrash;

/**
 *  Whether the current user can trash children of this folder. This is false
 *  when the item is not a folder. Only populated for items in shared drives.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canTrashChildren;

/**
 *  Whether the current user can restore this file from trash.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canUntrash;

@end


/**
 *  Additional information about the content of the file. These fields are never
 *  populated in responses.
 */
@interface GTLRDrive_File_ContentHints : GTLRObject

/**
 *  Text to be indexed for the file to improve fullText queries. This is limited
 *  to 128KB in length and may contain HTML elements.
 */
@property(nonatomic, copy, nullable) NSString *indexableText;

/**
 *  A thumbnail for the file. This will only be used if Google Drive cannot
 *  generate a standard thumbnail.
 */
@property(nonatomic, strong, nullable) GTLRDrive_File_ContentHints_Thumbnail *thumbnail;

@end


/**
 *  Links for exporting Docs Editors files to specific formats.
 *
 *  @note This class is documented as having more properties of NSString. Use @c
 *        -additionalJSONKeys and @c -additionalPropertyForName: to get the list
 *        of properties and then fetch them; or @c -additionalProperties to
 *        fetch them all at once.
 */
@interface GTLRDrive_File_ExportLinks : GTLRObject
@end


/**
 *  Additional metadata about image media, if available.
 */
@interface GTLRDrive_File_ImageMediaMetadata : GTLRObject

/**
 *  The aperture used to create the photo (f-number).
 *
 *  Uses NSNumber of floatValue.
 */
@property(nonatomic, strong, nullable) NSNumber *aperture;

/** The make of the camera used to create the photo. */
@property(nonatomic, copy, nullable) NSString *cameraMake;

/** The model of the camera used to create the photo. */
@property(nonatomic, copy, nullable) NSString *cameraModel;

/** The color space of the photo. */
@property(nonatomic, copy, nullable) NSString *colorSpace;

/**
 *  The exposure bias of the photo (APEX value).
 *
 *  Uses NSNumber of floatValue.
 */
@property(nonatomic, strong, nullable) NSNumber *exposureBias;

/** The exposure mode used to create the photo. */
@property(nonatomic, copy, nullable) NSString *exposureMode;

/**
 *  The length of the exposure, in seconds.
 *
 *  Uses NSNumber of floatValue.
 */
@property(nonatomic, strong, nullable) NSNumber *exposureTime;

/**
 *  Whether a flash was used to create the photo.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *flashUsed;

/**
 *  The focal length used to create the photo, in millimeters.
 *
 *  Uses NSNumber of floatValue.
 */
@property(nonatomic, strong, nullable) NSNumber *focalLength;

/**
 *  The height of the image in pixels.
 *
 *  Uses NSNumber of intValue.
 */
@property(nonatomic, strong, nullable) NSNumber *height;

/**
 *  The ISO speed used to create the photo.
 *
 *  Uses NSNumber of intValue.
 */
@property(nonatomic, strong, nullable) NSNumber *isoSpeed;

/** The lens used to create the photo. */
@property(nonatomic, copy, nullable) NSString *lens;

/** Geographic location information stored in the image. */
@property(nonatomic, strong, nullable) GTLRDrive_File_ImageMediaMetadata_Location *location;

/**
 *  The smallest f-number of the lens at the focal length used to create the
 *  photo (APEX value).
 *
 *  Uses NSNumber of floatValue.
 */
@property(nonatomic, strong, nullable) NSNumber *maxApertureValue;

/** The metering mode used to create the photo. */
@property(nonatomic, copy, nullable) NSString *meteringMode;

/**
 *  The number of clockwise 90 degree rotations applied from the image's
 *  original orientation.
 *
 *  Uses NSNumber of intValue.
 */
@property(nonatomic, strong, nullable) NSNumber *rotation;

/** The type of sensor used to create the photo. */
@property(nonatomic, copy, nullable) NSString *sensor;

/**
 *  The distance to the subject of the photo, in meters.
 *
 *  Uses NSNumber of intValue.
 */
@property(nonatomic, strong, nullable) NSNumber *subjectDistance;

/** The date and time the photo was taken (EXIF DateTime). */
@property(nonatomic, copy, nullable) NSString *time;

/** The white balance mode used to create the photo. */
@property(nonatomic, copy, nullable) NSString *whiteBalance;

/**
 *  The width of the image in pixels.
 *
 *  Uses NSNumber of intValue.
 */
@property(nonatomic, strong, nullable) NSNumber *width;

@end


/**
 *  A collection of arbitrary key-value pairs which are visible to all apps.
 *  Entries with null values are cleared in update and copy requests.
 *
 *  @note This class is documented as having more properties of NSString. Use @c
 *        -additionalJSONKeys and @c -additionalPropertyForName: to get the list
 *        of properties and then fetch them; or @c -additionalProperties to
 *        fetch them all at once.
 */
@interface GTLRDrive_File_Properties : GTLRObject
@end


/**
 *  Shortcut file details. Only populated for shortcut files, which have the
 *  mimeType field set to application/vnd.google-apps.shortcut.
 */
@interface GTLRDrive_File_ShortcutDetails : GTLRObject

/** The ID of the file that this shortcut points to. */
@property(nonatomic, copy, nullable) NSString *targetId;

/**
 *  The MIME type of the file that this shortcut points to. The value of this
 *  field is a snapshot of the target's MIME type, captured when the shortcut is
 *  created.
 */
@property(nonatomic, copy, nullable) NSString *targetMimeType;

@end


/**
 *  Additional metadata about video media. This may not be available immediately
 *  upon upload.
 */
@interface GTLRDrive_File_VideoMediaMetadata : GTLRObject

/**
 *  The duration of the video in milliseconds.
 *
 *  Uses NSNumber of longLongValue.
 */
@property(nonatomic, strong, nullable) NSNumber *durationMillis;

/**
 *  The height of the video in pixels.
 *
 *  Uses NSNumber of intValue.
 */
@property(nonatomic, strong, nullable) NSNumber *height;

/**
 *  The width of the video in pixels.
 *
 *  Uses NSNumber of intValue.
 */
@property(nonatomic, strong, nullable) NSNumber *width;

@end


/**
 *  A thumbnail for the file. This will only be used if Google Drive cannot
 *  generate a standard thumbnail.
 */
@interface GTLRDrive_File_ContentHints_Thumbnail : GTLRObject

/**
 *  The thumbnail data encoded with URL-safe Base64 (RFC 4648 section 5).
 *
 *  Contains encoded binary data; GTLRBase64 can encode/decode (probably
 *  web-safe format).
 */
@property(nonatomic, copy, nullable) NSString *image;

/** The MIME type of the thumbnail. */
@property(nonatomic, copy, nullable) NSString *mimeType;

@end


/**
 *  Geographic location information stored in the image.
 */
@interface GTLRDrive_File_ImageMediaMetadata_Location : GTLRObject

/**
 *  The altitude stored in the image.
 *
 *  Uses NSNumber of doubleValue.
 */
@property(nonatomic, strong, nullable) NSNumber *altitude;

/**
 *  The latitude stored in the image.
 *
 *  Uses NSNumber of doubleValue.
 */
@property(nonatomic, strong, nullable) NSNumber *latitude;

/**
 *  The longitude stored in the image.
 *
 *  Uses NSNumber of doubleValue.
 */
@property(nonatomic, strong, nullable) NSNumber *longitude;

@end


/**
 *  A list of files.
 *
 *  @note This class supports NSFastEnumeration and indexed subscripting over
 *        its "files" property. If returned as the result of a query, it should
 *        support automatic pagination (when @c shouldFetchNextPages is
 *        enabled).
 */
@interface GTLRDrive_FileList : GTLRCollectionObject

/**
 *  The list of files. If nextPageToken is populated, then this list may be
 *  incomplete and an additional page of results should be fetched.
 *
 *  @note This property is used to support NSFastEnumeration and indexed
 *        subscripting on this class.
 */
@property(nonatomic, strong, nullable) NSArray<GTLRDrive_File *> *files;

/**
 *  Whether the search process was incomplete. If true, then some search results
 *  may be missing, since all documents were not searched. This may occur when
 *  searching multiple drives with the "allDrives" corpora, but all corpora
 *  could not be searched. When this happens, it is suggested that clients
 *  narrow their query by choosing a different corpus such as "user" or "drive".
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *incompleteSearch;

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#fileList".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/**
 *  The page token for the next page of files. This will be absent if the end of
 *  the files list has been reached. If the token is rejected for any reason, it
 *  should be discarded, and pagination should be restarted from the first page
 *  of results.
 */
@property(nonatomic, copy, nullable) NSString *nextPageToken;

@end


/**
 *  A list of generated file IDs which can be provided in create requests.
 */
@interface GTLRDrive_GeneratedIds : GTLRObject

/** The IDs generated for the requesting user in the specified space. */
@property(nonatomic, strong, nullable) NSArray<NSString *> *ids;

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#generatedIds".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/** The type of file that can be created with these IDs. */
@property(nonatomic, copy, nullable) NSString *space;

@end


/**
 *  A permission for a file. A permission grants a user, group, domain or the
 *  world access to a file or a folder hierarchy.
 */
@interface GTLRDrive_Permission : GTLRObject

/**
 *  Whether the permission allows the file to be discovered through search. This
 *  is only applicable for permissions of type domain or anyone.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *allowFileDiscovery;

/**
 *  Whether the account associated with this permission has been deleted. This
 *  field only pertains to user and group permissions.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *deleted;

/**
 *  The "pretty" name of the value of the permission. The following is a list of
 *  examples for each type of permission:
 *  - user - User's full name, as defined for their Google account, such as "Joe
 *  Smith."
 *  - group - Name of the Google Group, such as "The Company Administrators."
 *  - domain - String domain name, such as "thecompany.com."
 *  - anyone - No displayName is present.
 */
@property(nonatomic, copy, nullable) NSString *displayName;

/** The domain to which this permission refers. */
@property(nonatomic, copy, nullable) NSString *domain;

/** The email address of the user or group to which this permission refers. */
@property(nonatomic, copy, nullable) NSString *emailAddress;

/**
 *  The time at which this permission will expire (RFC 3339 date-time).
 *  Expiration times have the following restrictions:
 *  - They can only be set on user and group permissions
 *  - The time must be in the future
 *  - The time cannot be more than a year in the future
 */
@property(nonatomic, strong, nullable) GTLRDateTime *expirationTime;

/**
 *  The ID of this permission. This is a unique identifier for the grantee, and
 *  is published in User resources as permissionId. IDs should be treated as
 *  opaque values.
 *
 *  identifier property maps to 'id' in JSON (to avoid Objective C's 'id').
 */
@property(nonatomic, copy, nullable) NSString *identifier;

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#permission".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/**
 *  Details of whether the permissions on this shared drive item are inherited
 *  or directly on this item. This is an output-only field which is present only
 *  for shared drive items.
 */
@property(nonatomic, strong, nullable) NSArray<GTLRDrive_Permission_PermissionDetails_Item *> *permissionDetails;

/** A link to the user's profile photo, if available. */
@property(nonatomic, copy, nullable) NSString *photoLink;

/**
 *  The role granted by this permission. While new values may be supported in
 *  the future, the following are currently allowed:
 *  - owner
 *  - organizer
 *  - fileOrganizer
 *  - writer
 *  - commenter
 *  - reader
 */
@property(nonatomic, copy, nullable) NSString *role;

/** Deprecated - use permissionDetails instead. */
@property(nonatomic, strong, nullable) NSArray<GTLRDrive_Permission_TeamDrivePermissionDetails_Item *> *teamDrivePermissionDetails;

/**
 *  The type of the grantee. Valid values are:
 *  - user
 *  - group
 *  - domain
 *  - anyone When creating a permission, if type is user or group, you must
 *  provide an emailAddress for the user or group. When type is domain, you must
 *  provide a domain. There isn't extra information required for a anyone type.
 */
@property(nonatomic, copy, nullable) NSString *type;

/**
 *  Indicates the view for this permission. Only populated for permissions that
 *  belong to a view. published is the only supported value.
 */
@property(nonatomic, copy, nullable) NSString *view;

@end


/**
 *  GTLRDrive_Permission_PermissionDetails_Item
 */
@interface GTLRDrive_Permission_PermissionDetails_Item : GTLRObject

/**
 *  Whether this permission is inherited. This field is always populated. This
 *  is an output-only field.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *inherited;

/**
 *  The ID of the item from which this permission is inherited. This is an
 *  output-only field.
 */
@property(nonatomic, copy, nullable) NSString *inheritedFrom;

/**
 *  The permission type for this user. While new values may be added in future,
 *  the following are currently possible:
 *  - file
 *  - member
 */
@property(nonatomic, copy, nullable) NSString *permissionType;

/**
 *  The primary role for this user. While new values may be added in the future,
 *  the following are currently possible:
 *  - organizer
 *  - fileOrganizer
 *  - writer
 *  - commenter
 *  - reader
 */
@property(nonatomic, copy, nullable) NSString *role;

@end


/**
 *  GTLRDrive_Permission_TeamDrivePermissionDetails_Item
 */
@interface GTLRDrive_Permission_TeamDrivePermissionDetails_Item : GTLRObject

/**
 *  Deprecated - use permissionDetails/inherited instead.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *inherited;

/** Deprecated - use permissionDetails/inheritedFrom instead. */
@property(nonatomic, copy, nullable) NSString *inheritedFrom;

/** Deprecated - use permissionDetails/role instead. */
@property(nonatomic, copy, nullable) NSString *role;

/** Deprecated - use permissionDetails/permissionType instead. */
@property(nonatomic, copy, nullable) NSString *teamDrivePermissionType;

@end


/**
 *  A list of permissions for a file.
 *
 *  @note This class supports NSFastEnumeration and indexed subscripting over
 *        its "permissions" property. If returned as the result of a query, it
 *        should support automatic pagination (when @c shouldFetchNextPages is
 *        enabled).
 */
@interface GTLRDrive_PermissionList : GTLRCollectionObject

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#permissionList".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/**
 *  The page token for the next page of permissions. This field will be absent
 *  if the end of the permissions list has been reached. If the token is
 *  rejected for any reason, it should be discarded, and pagination should be
 *  restarted from the first page of results.
 */
@property(nonatomic, copy, nullable) NSString *nextPageToken;

/**
 *  The list of permissions. If nextPageToken is populated, then this list may
 *  be incomplete and an additional page of results should be fetched.
 *
 *  @note This property is used to support NSFastEnumeration and indexed
 *        subscripting on this class.
 */
@property(nonatomic, strong, nullable) NSArray<GTLRDrive_Permission *> *permissions;

@end


/**
 *  A reply to a comment on a file.
 */
@interface GTLRDrive_Reply : GTLRObject

/**
 *  The action the reply performed to the parent comment. Valid values are:
 *  - resolve
 *  - reopen
 */
@property(nonatomic, copy, nullable) NSString *action;

/**
 *  The author of the reply. The author's email address and permission ID will
 *  not be populated.
 */
@property(nonatomic, strong, nullable) GTLRDrive_User *author;

/**
 *  The plain text content of the reply. This field is used for setting the
 *  content, while htmlContent should be displayed. This is required on creates
 *  if no action is specified.
 */
@property(nonatomic, copy, nullable) NSString *content;

/** The time at which the reply was created (RFC 3339 date-time). */
@property(nonatomic, strong, nullable) GTLRDateTime *createdTime;

/**
 *  Whether the reply has been deleted. A deleted reply has no content.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *deleted;

/** The content of the reply with HTML formatting. */
@property(nonatomic, copy, nullable) NSString *htmlContent;

/**
 *  The ID of the reply.
 *
 *  identifier property maps to 'id' in JSON (to avoid Objective C's 'id').
 */
@property(nonatomic, copy, nullable) NSString *identifier;

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#reply".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/** The last time the reply was modified (RFC 3339 date-time). */
@property(nonatomic, strong, nullable) GTLRDateTime *modifiedTime;

@end


/**
 *  A list of replies to a comment on a file.
 *
 *  @note This class supports NSFastEnumeration and indexed subscripting over
 *        its "replies" property. If returned as the result of a query, it
 *        should support automatic pagination (when @c shouldFetchNextPages is
 *        enabled).
 */
@interface GTLRDrive_ReplyList : GTLRCollectionObject

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#replyList".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/**
 *  The page token for the next page of replies. This will be absent if the end
 *  of the replies list has been reached. If the token is rejected for any
 *  reason, it should be discarded, and pagination should be restarted from the
 *  first page of results.
 */
@property(nonatomic, copy, nullable) NSString *nextPageToken;

/**
 *  The list of replies. If nextPageToken is populated, then this list may be
 *  incomplete and an additional page of results should be fetched.
 *
 *  @note This property is used to support NSFastEnumeration and indexed
 *        subscripting on this class.
 */
@property(nonatomic, strong, nullable) NSArray<GTLRDrive_Reply *> *replies;

@end


/**
 *  The metadata for a revision to a file.
 */
@interface GTLRDrive_Revision : GTLRObject

/** Links for exporting Docs Editors files to specific formats. */
@property(nonatomic, strong, nullable) GTLRDrive_Revision_ExportLinks *exportLinks;

/**
 *  The ID of the revision.
 *
 *  identifier property maps to 'id' in JSON (to avoid Objective C's 'id').
 */
@property(nonatomic, copy, nullable) NSString *identifier;

/**
 *  Whether to keep this revision forever, even if it is no longer the head
 *  revision. If not set, the revision will be automatically purged 30 days
 *  after newer content is uploaded. This can be set on a maximum of 200
 *  revisions for a file.
 *  This field is only applicable to files with binary content in Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *keepForever;

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#revision".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/** The last user to modify this revision. */
@property(nonatomic, strong, nullable) GTLRDrive_User *lastModifyingUser;

/**
 *  The MD5 checksum of the revision's content. This is only applicable to files
 *  with binary content in Drive.
 */
@property(nonatomic, copy, nullable) NSString *md5Checksum;

/** The MIME type of the revision. */
@property(nonatomic, copy, nullable) NSString *mimeType;

/** The last time the revision was modified (RFC 3339 date-time). */
@property(nonatomic, strong, nullable) GTLRDateTime *modifiedTime;

/**
 *  The original filename used to create this revision. This is only applicable
 *  to files with binary content in Drive.
 */
@property(nonatomic, copy, nullable) NSString *originalFilename;

/**
 *  Whether subsequent revisions will be automatically republished. This is only
 *  applicable to Docs Editors files.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *publishAuto;

/**
 *  Whether this revision is published. This is only applicable to Docs Editors
 *  files.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *published;

/**
 *  A link to the published revision. This is only populated for Google Sites
 *  files.
 */
@property(nonatomic, copy, nullable) NSString *publishedLink;

/**
 *  Whether this revision is published outside the domain. This is only
 *  applicable to Docs Editors files.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *publishedOutsideDomain;

/**
 *  The size of the revision's content in bytes. This is only applicable to
 *  files with binary content in Drive.
 *
 *  Uses NSNumber of longLongValue.
 */
@property(nonatomic, strong, nullable) NSNumber *size;

@end


/**
 *  Links for exporting Docs Editors files to specific formats.
 *
 *  @note This class is documented as having more properties of NSString. Use @c
 *        -additionalJSONKeys and @c -additionalPropertyForName: to get the list
 *        of properties and then fetch them; or @c -additionalProperties to
 *        fetch them all at once.
 */
@interface GTLRDrive_Revision_ExportLinks : GTLRObject
@end


/**
 *  A list of revisions of a file.
 *
 *  @note This class supports NSFastEnumeration and indexed subscripting over
 *        its "revisions" property. If returned as the result of a query, it
 *        should support automatic pagination (when @c shouldFetchNextPages is
 *        enabled).
 */
@interface GTLRDrive_RevisionList : GTLRCollectionObject

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#revisionList".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/**
 *  The page token for the next page of revisions. This will be absent if the
 *  end of the revisions list has been reached. If the token is rejected for any
 *  reason, it should be discarded, and pagination should be restarted from the
 *  first page of results.
 */
@property(nonatomic, copy, nullable) NSString *nextPageToken;

/**
 *  The list of revisions. If nextPageToken is populated, then this list may be
 *  incomplete and an additional page of results should be fetched.
 *
 *  @note This property is used to support NSFastEnumeration and indexed
 *        subscripting on this class.
 */
@property(nonatomic, strong, nullable) NSArray<GTLRDrive_Revision *> *revisions;

@end


/**
 *  GTLRDrive_StartPageToken
 */
@interface GTLRDrive_StartPageToken : GTLRObject

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#startPageToken".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/** The starting page token for listing changes. */
@property(nonatomic, copy, nullable) NSString *startPageToken;

@end


/**
 *  Deprecated: use the drive collection instead.
 */
@interface GTLRDrive_TeamDrive : GTLRObject

/**
 *  An image file and cropping parameters from which a background image for this
 *  Team Drive is set. This is a write only field; it can only be set on
 *  drive.teamdrives.update requests that don't set themeId. When specified, all
 *  fields of the backgroundImageFile must be set.
 */
@property(nonatomic, strong, nullable) GTLRDrive_TeamDrive_BackgroundImageFile *backgroundImageFile;

/** A short-lived link to this Team Drive's background image. */
@property(nonatomic, copy, nullable) NSString *backgroundImageLink;

/** Capabilities the current user has on this Team Drive. */
@property(nonatomic, strong, nullable) GTLRDrive_TeamDrive_Capabilities *capabilities;

/**
 *  The color of this Team Drive as an RGB hex string. It can only be set on a
 *  drive.teamdrives.update request that does not set themeId.
 */
@property(nonatomic, copy, nullable) NSString *colorRgb;

/** The time at which the Team Drive was created (RFC 3339 date-time). */
@property(nonatomic, strong, nullable) GTLRDateTime *createdTime;

/**
 *  The ID of this Team Drive which is also the ID of the top level folder of
 *  this Team Drive.
 *
 *  identifier property maps to 'id' in JSON (to avoid Objective C's 'id').
 */
@property(nonatomic, copy, nullable) NSString *identifier;

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#teamDrive".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/** The name of this Team Drive. */
@property(nonatomic, copy, nullable) NSString *name;

/**
 *  A set of restrictions that apply to this Team Drive or items inside this
 *  Team Drive.
 */
@property(nonatomic, strong, nullable) GTLRDrive_TeamDrive_Restrictions *restrictions;

/**
 *  The ID of the theme from which the background image and color will be set.
 *  The set of possible teamDriveThemes can be retrieved from a drive.about.get
 *  response. When not specified on a drive.teamdrives.create request, a random
 *  theme is chosen from which the background image and color are set. This is a
 *  write-only field; it can only be set on requests that don't set colorRgb or
 *  backgroundImageFile.
 */
@property(nonatomic, copy, nullable) NSString *themeId;

@end


/**
 *  An image file and cropping parameters from which a background image for this
 *  Team Drive is set. This is a write only field; it can only be set on
 *  drive.teamdrives.update requests that don't set themeId. When specified, all
 *  fields of the backgroundImageFile must be set.
 */
@interface GTLRDrive_TeamDrive_BackgroundImageFile : GTLRObject

/**
 *  The ID of an image file in Drive to use for the background image.
 *
 *  identifier property maps to 'id' in JSON (to avoid Objective C's 'id').
 */
@property(nonatomic, copy, nullable) NSString *identifier;

/**
 *  The width of the cropped image in the closed range of 0 to 1. This value
 *  represents the width of the cropped image divided by the width of the entire
 *  image. The height is computed by applying a width to height aspect ratio of
 *  80 to 9. The resulting image must be at least 1280 pixels wide and 144
 *  pixels high.
 *
 *  Uses NSNumber of floatValue.
 */
@property(nonatomic, strong, nullable) NSNumber *width;

/**
 *  The X coordinate of the upper left corner of the cropping area in the
 *  background image. This is a value in the closed range of 0 to 1. This value
 *  represents the horizontal distance from the left side of the entire image to
 *  the left side of the cropping area divided by the width of the entire image.
 *
 *  Uses NSNumber of floatValue.
 */
@property(nonatomic, strong, nullable) NSNumber *xCoordinate;

/**
 *  The Y coordinate of the upper left corner of the cropping area in the
 *  background image. This is a value in the closed range of 0 to 1. This value
 *  represents the vertical distance from the top side of the entire image to
 *  the top side of the cropping area divided by the height of the entire image.
 *
 *  Uses NSNumber of floatValue.
 */
@property(nonatomic, strong, nullable) NSNumber *yCoordinate;

@end


/**
 *  Capabilities the current user has on this Team Drive.
 */
@interface GTLRDrive_TeamDrive_Capabilities : GTLRObject

/**
 *  Whether the current user can add children to folders in this Team Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canAddChildren;

/**
 *  Whether the current user can change the copyRequiresWriterPermission
 *  restriction of this Team Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canChangeCopyRequiresWriterPermissionRestriction;

/**
 *  Whether the current user can change the domainUsersOnly restriction of this
 *  Team Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canChangeDomainUsersOnlyRestriction;

/**
 *  Whether the current user can change the background of this Team Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canChangeTeamDriveBackground;

/**
 *  Whether the current user can change the teamMembersOnly restriction of this
 *  Team Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canChangeTeamMembersOnlyRestriction;

/**
 *  Whether the current user can comment on files in this Team Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canComment;

/**
 *  Whether the current user can copy files in this Team Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canCopy;

/**
 *  Whether the current user can delete children from folders in this Team
 *  Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canDeleteChildren;

/**
 *  Whether the current user can delete this Team Drive. Attempting to delete
 *  the Team Drive may still fail if there are untrashed items inside the Team
 *  Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canDeleteTeamDrive;

/**
 *  Whether the current user can download files in this Team Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canDownload;

/**
 *  Whether the current user can edit files in this Team Drive
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canEdit;

/**
 *  Whether the current user can list the children of folders in this Team
 *  Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canListChildren;

/**
 *  Whether the current user can add members to this Team Drive or remove them
 *  or change their role.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canManageMembers;

/**
 *  Whether the current user can read the revisions resource of files in this
 *  Team Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canReadRevisions;

/**
 *  Deprecated - use canDeleteChildren or canTrashChildren instead.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canRemoveChildren;

/**
 *  Whether the current user can rename files or folders in this Team Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canRename;

/**
 *  Whether the current user can rename this Team Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canRenameTeamDrive;

/**
 *  Whether the current user can share files or folders in this Team Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canShare;

/**
 *  Whether the current user can trash children from folders in this Team Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *canTrashChildren;

@end


/**
 *  A set of restrictions that apply to this Team Drive or items inside this
 *  Team Drive.
 */
@interface GTLRDrive_TeamDrive_Restrictions : GTLRObject

/**
 *  Whether administrative privileges on this Team Drive are required to modify
 *  restrictions.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *adminManagedRestrictions;

/**
 *  Whether the options to copy, print, or download files inside this Team
 *  Drive, should be disabled for readers and commenters. When this restriction
 *  is set to true, it will override the similarly named field to true for any
 *  file inside this Team Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *copyRequiresWriterPermission NS_RETURNS_NOT_RETAINED;

/**
 *  Whether access to this Team Drive and items inside this Team Drive is
 *  restricted to users of the domain to which this Team Drive belongs. This
 *  restriction may be overridden by other sharing policies controlled outside
 *  of this Team Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *domainUsersOnly;

/**
 *  Whether access to items inside this Team Drive is restricted to members of
 *  this Team Drive.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *teamMembersOnly;

@end


/**
 *  A list of Team Drives.
 *
 *  @note This class supports NSFastEnumeration and indexed subscripting over
 *        its "teamDrives" property. If returned as the result of a query, it
 *        should support automatic pagination (when @c shouldFetchNextPages is
 *        enabled).
 */
@interface GTLRDrive_TeamDriveList : GTLRCollectionObject

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#teamDriveList".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/**
 *  The page token for the next page of Team Drives. This will be absent if the
 *  end of the Team Drives list has been reached. If the token is rejected for
 *  any reason, it should be discarded, and pagination should be restarted from
 *  the first page of results.
 */
@property(nonatomic, copy, nullable) NSString *nextPageToken;

/**
 *  The list of Team Drives. If nextPageToken is populated, then this list may
 *  be incomplete and an additional page of results should be fetched.
 *
 *  @note This property is used to support NSFastEnumeration and indexed
 *        subscripting on this class.
 */
@property(nonatomic, strong, nullable) NSArray<GTLRDrive_TeamDrive *> *teamDrives;

@end


/**
 *  Information about a Drive user.
 */
@interface GTLRDrive_User : GTLRObject

/** A plain text displayable name for this user. */
@property(nonatomic, copy, nullable) NSString *displayName;

/**
 *  The email address of the user. This may not be present in certain contexts
 *  if the user has not made their email address visible to the requester.
 */
@property(nonatomic, copy, nullable) NSString *emailAddress;

/**
 *  Identifies what kind of resource this is. Value: the fixed string
 *  "drive#user".
 */
@property(nonatomic, copy, nullable) NSString *kind;

/**
 *  Whether this user is the requesting user.
 *
 *  Uses NSNumber of boolValue.
 */
@property(nonatomic, strong, nullable) NSNumber *me;

/** The user's ID as visible in Permission resources. */
@property(nonatomic, copy, nullable) NSString *permissionId;

/** A link to the user's profile photo, if available. */
@property(nonatomic, copy, nullable) NSString *photoLink;

@end

NS_ASSUME_NONNULL_END

#pragma clang diagnostic pop
