//
//  UIImage+Additions.h
//  
//
//  Created by Mike on 13/5/2.
//  
//

#import <UIKit/UIKit.h>
#import "UIImage+PropertyDictionary.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSString * const UIImageResourceType_PNG   = @"png";
static NSString * const UIImageResourceType_JPG   = @"jpg";

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSString * const UIImageState_Disabled     = @"-Disabled";
static NSString * const UIImageState_Highlighted  = @"-Highlighted";
static NSString * const UIImageState_Normal       = @"-Normal";
static NSString * const UIImageState_Selected     = @"-Selected";

////////////////////////////////////////////////////////////////////////////////////////////////////

static inline CGFloat degreesFromRadians (CGFloat radians) {return radians*180/M_PI;}
static inline CGFloat radiansFromDegrees (CGFloat degrees) {return degrees*M_PI/180;}

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface UIImage (Additions)

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance Methods

/// 配合macOS加入的函式，取得影像真正大小，在iOS和size是相同的。
- (CGSize)actualSize;

- (UIImage *)imageAdjustWithBrightness:(NSInteger)brightness contrast:(NSInteger)contrast;
- (UIImage *)imageCroppedByRect:(CGRect)rect;
- (UIImage *)imageReflectionByFraction:(CGFloat)fraction;
- (UIImage *)imageRotatedByDegrees:(CGFloat)degrees scalingMaxLength:(CGFloat)maxLength;
- (UIImage *)imageRotatedByDegrees:(CGFloat)degrees;
- (UIImage *)imageRotatedByRadians:(CGFloat)radians;
- (UIImage *)imageScalingMaxLength:(CGFloat)maxLength;
- (CGSize)sizeRotatedByDegrees:(CGFloat)degrees scalingToFitSize:(CGSize)fitSize;
- (CGSize)sizeRotatedByDegrees:(CGFloat)degrees scalingToMaxLength:(CGFloat)maxLength;
- (NSData *)dataOfRGBA;


/**
 * 取得jpeg data
 * @param compressQuality 壓縮比
 * @return NSData jpeg data
 */
- (NSData *)jpegRepresentationWithCompressQuality:(CGFloat)compressQuality;

/**
 * png data
 * @return NSData PNG data
 */
- (NSData *)pngRepresentation;

/** 
 * 建立水平放大影像。左右兩邊不動，只拉伸中間部分。
 *
 * @param leftCap 左邊不動的長度
 * @param rightCap 右邊不動的長度
 * @param newWidth 新的影像寬度
 * @return Expanded image
**/
- (UIImage *)imageHorzExpandedWithLeftCap:(CGFloat)leftCap rightCap:(CGFloat)rightCap newWidth:(CGFloat)newWidth;


/**
 * 建立放大影像。四角不動，只拉伸其他部分。
 *
 * @param fixedCornerCap 四角不動的長度
 * @param newSize 新的影像大小
 * @return Expanded image
 **/
- (UIImage *)imageExpandedWithFixedCornerCap:(CGFloat)fixedCornerCap newSize:(CGSize)newSize;


/** 
 * 建立局部影像
 *
 * @return Clipped image
 **/
- (UIImage *)imageInRect:(CGRect)rect;


/**
 * 建立imageOrientation修正後的影像
 * （WC系列從UIImagePickerController取得的影像一定要先用此函式修正）
 *
 * @param maxLength 較長邊最大長度 (0表示不縮放)
 * @return Fixed image
 **/
- (UIImage *)imageByAdjustOrientationWithMaxLength:(NSInteger)maxLength;


/// 移除白色背景
- (UIImage *)removeWhiteBackgroundColor;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (UIImage *)imageWithColor:(UIColor *)color;

/**
 *  回傳單色 image, 且 resize 至 size.
 *
 *  @param color 顏色
 *  @param size  結果影像大小
 *
 *  @return 單色Image
 */
+ (UIImage *)imageWithColor:(UIColor *)color size:(CGSize)size;

+ (UIImage *)imageWithName:(NSString *)name;
+ (UIImage *)imageWithName:(NSString *)name forState:(UIControlState)state;
+ (UIImage *)imageWithName:(NSString *)name forState:(UIControlState)state resizableCapInsets:(UIEdgeInsets)capInsets;
+ (NSUInteger)bytesPerRowWithWidth:(NSUInteger)width bitCount:(NSUInteger)bitCount;


@end
