//
//  NSFileManager+Additions.h
//  
//
//  Created by Mike on 13/5/8.
//  
//

#import <Foundation/Foundation.h>
#import "NSError+Custom.h"

@interface NSFileManager (Additions)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (BOOL)createDirectoryAtPath:(NSString *)path error:(NSError **)error;
- (BOOL)removeContentsAtPath:(NSString *)path error:(NSError **)error;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (BOOL)createDirectoryAtPath:(NSString *)path error:(NSError **)error;
+ (BOOL)copyItemAtPath:(NSString *)atPath toPath:(NSString *)toPath error:(NSError **)error;
+ (BOOL)moveItemAtPath:(NSString *)atPath toPath:(NSString *)toPath error:(NSError **)error;
+ (BOOL)removeItemAtPath:(NSString *)path error:(NSError **)error;
+ (BOOL)removeContentsAtPath:(NSString *)path error:(NSError **)error;


/**
 取得目錄下，所有檔案大小

 @param folderPath 檔案路徑
 @return 檔案大小
 */
+ (unsigned long long)folderSize:(NSString *)folderPath;


/**
 取得路徑所屬磁碟可用空間大小
 
 @param path 檔案路徑
 @return 可用空間大小
 */
+ (unsigned long long)diskFreeSizeWithPath:(NSString *)path;


/**
 檢查系統磁碟是否還有足夠的磁碟空間
 
 @param requestSize 需要的磁碟空間大小
 @return YES代表有足夠空間
 */
+ (BOOL)hasEnoughDiskSpaceWithSize:(unsigned long long)requestSize;


/**
 取得檔案大小
 */
+ (unsigned long long)fileSizeWithPath:(NSString *)path error:(NSError **)error;

@end
