extern unsigned short CHFindVoice(unsigned short *pstr, int mode);
extern unsigned short KSFindVoice(unsigned short code, int mode);
extern unsigned short JPFindVoice(const char* aDBPath, unsigned short *unicodeStr, unsigned short *pVoice);
extern unsigned short JPKana2index(unsigned short code);

/*
輸入: pstr 泰文字串
輸出: 0-43 讀音index, 若無法對應則為255
*/
extern unsigned char THThai2index(unsigned short *pstr);



/*
 sample:
 ------------------------------------------------------
 unsigned short code[] = {0x8499};
 unsigned short zupin = CHFindVoice(code, 1); // 注音
 unsigned short hanpin = CHFindVoice(code, 2); // 漢拼
 unsigned short stroke = CHFindVoice(code, 3); // 筆劃
 
 unsigned short hangul = KSFindVoice(0x8499, 1); // 韓文拼音
 unsigned short inital = KSFindVoice(0x8499, 0); // 部首
 
 unsigned short szVoice[255]={0x00}; // 建議使用255個 short array
 unsigned short japcode[] = {0x8499, 0x606C, 0x79D1, 0x6280, 0x0000}; // 需要0x0000結束符號
 
 int rtn = JPFindVoice(japcode, szVoice); // 日文拼音,以0x7C做分隔符號

*/
