//
//  WCWLSXDataController.h
//  Pods
//
//  Created by sanhue on 2016/5/20.
//
//

#import <Foundation/Foundation.h>
#import "WCCardModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Error code of WCCSVDataController

typedef NS_OPTIONS(NSInteger, WCXLSXDataController_Error)
{
    WCXLSXDataController_Error_Unknown = 0,
    WCXLSXDataController_Error_CreateWorkbookFailed,
    WCXLSXDataController_Error_CreateWorksheetFailed,
    WCXLSXDataController_Error_NoCardToWrite,
    WCXLSXDataController_Error_MustHaveDelegateMethod,
    WCXLSXDataController_Error_FailedToInitObject,
    WCXLSXDataController_Error_FailedToOpenFileForWriting,
    WCXLSXDataController_Error_FailedToWriteCardInfo,
    WCXLSXDataController_Error_CancelWriteCard,
};

////////////////////////////////////////////////////////////////////////////////////////////////////
/// WCCSVDataControllerDelegate

@class WCXLSXDataController;
@protocol WCXLSXDataControllerDelegate <NSObject>
@optional

/**
 * Request field data to write
 *
 * @param xlsxDataContrller - Data controller instance
 * @param cardID - Card that need get field data
 * @return WCCardModel with field data of card
 */
- (WCCardModel *)xlsxDataContrller:(WCXLSXDataController *)xlsxDataContrller
       cardModelToWriteWithCardID:(NSString *)cardID;

/**
 * Request group name
 *
 * @param xlsxDataContrller - Data controller instance
 * @param groupID - Group identifier need to get name
 * @return NSString with group name
 */
- (NSString *)xlsxDataContrller:(WCXLSXDataController *)xlsxDataContrller
   groupNameToWriteWithGroupID:(WC_GroupID)groupID;


/**
 * Ask one card should be writed
 *
 * @param xlsxDataContrller - Data controller instance
 * @param index - Write card index
 * @param totalCount - Total count
 */
- (BOOL)xlsxDataContrller:(WCXLSXDataController *)xlsxDataContrller
 shouldWriteCardWithIndex:(NSInteger)index
               totalCount:(NSInteger)totalCount;

/**
 * Notify one card is write finish
 *
 * @param xlsxDataContrller - Data controller instance
 * @param index - Write card index
 * @param totalCount - Total count
 */
- (void)xlsxDataContrller:(WCXLSXDataController *)xlsxDataContrller
   didWriteCardWithIndex:(NSInteger)index
              totalCount:(NSInteger)totalCount;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCXLSXDataController : NSObject


#pragma mark public methods
/**
 * Initialize
 *
 * @param delegate - Instance that can handle WCXFDataControllerDelegate
 * @return WCXFDataController instance
 */
- (instancetype)initWithDelegate:(id<WCXLSXDataControllerDelegate>)delegate;

/**
 * Write WLSX
 *
 * @param filePath - WLSX file path
 * @param cardIDs - Cards that wnat to write
 * @param error - return error
 * @return YES if success
 */
- (BOOL)writeFileWithPath:(NSString *)filePath
                  cardIDs:(NSArray *)cardIDs
                    error:(NSError **)error;

#pragma mark class methods

/// 匯出內容是否要包含姓名讀音，請在 |initWithDelegate:|之前設定好，預設 NO
+ (void)setShouldShowNamePhonetic:(BOOL)shouldShowNamePhonetic;

/// 匯出內容是否要包含公司讀音，請在 |initWithDelegate:|之前設定好，預設 NO
+ (void)setShouldShowCompanyPhonetic:(BOOL)shouldShowPhonetic;


/**
 匯出內容，公司欄位是否只包含公司完整地址

 @param fullAddressOnly YES, 只包含公司完整地址;  NO, 包含公司完整地址+欄位
 */
+ (void)setExportFullAddressOnly:(BOOL)fullAddressOnly;
@end
