//
//  WCTSyncFlowController.h
//  Example
//
//  Created by Eddie Hu on 2016/4/11.
//  Copyright © 2016年 penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "WCSyncFlowDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCTSyncFlowController : NSObject

/**
 取得log資料夾路徑

 @return log資料夾路徑
 */
+ (NSString *)logDirPath;


/**
 開始同步

 @param availableNetwork 可以執行同步的網路型態（WiFi or WiFi+3G）
 @param isAutoMode 是否為自動同步模式
 */
+ (void)syncWithAvailableNetwork:(WCSyncFlow_Network)availableNetwork
                      isAutoMode:(BOOL)isAutoMode;


/**
 取消同步
 */
+ (void)cancelSync;


/**
 取得目前進行的流程

 @return 進行的流程
 */
+ (WCSyncFlow_Flow)currentFlow;


/**
 取得同步目前進行的比例

 @return 目前進行的比例
 */
+ (CGFloat)currentSyncProgress;


/**
 取得最近同步成功的時間

 @return 最近同步成功的時間
 */
+ (NSDate *)lastSyncActionSuccessDate;


/**
 恢復成第一次同步的設定
 */
+ (void)resetToFirstSync;


/**
 當兩邊資料不一致時，開啟這個flag後再同步，可以強制重新比對
 */
+ (void)forceRecompareSync;


/**
 取得最近一次執行同步是否為自動模式

 @return YES代表在自動模式下進行同步
 */
+ (BOOL)isAutoMode;

@end
