//
//  WCTSyncActionController.h
//  Pods
//
//  Created by Eddie Hu on 2016/4/11.
//
//

#import "PPSyncActionController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

/// 錯誤碼
typedef NS_OPTIONS(NSInteger, WCTSyncActionControllerError)
{
    WCTSyncActionControllerError_None = 8000,
    WCTSyncActionControllerError_WrongParameter,
    WCTSyncActionControllerError_InitObjectFailed,
    WCTSyncActionControllerError_OperationFailed,
    WCTSyncActionControllerError_NotEnoughDiskSpace,
};

/// 同步步驟
typedef NS_ENUM(NSUInteger, WCTSyncActionControllerStep)
{
    WCTSyncActionControllerStep_None = 0,
    WCTSyncActionControllerStep_GetNomalSyncInfo,
//    WCTSyncActionControllerStep_GetLocalCategorySyncInfo,
    WCTSyncActionControllerStep_GetLocalContactSyncInfo,
    WCTSyncActionControllerStep_FetchUpdateActions_Stage1,  //前10筆
    WCTSyncActionControllerStep_FetchUpdateActions_Stage2,  //第11筆之後
    WCTSyncActionControllerStep_ApplyContactUpdateActions,
    WCTSyncActionControllerStep_SyncDone,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCTSyncActionController : PPSyncActionController

- (BOOL)syncWithError:(NSError **)error quickSyncVaildTimeInterval:(NSTimeInterval)quickSyncVaildTimeInterval;

/**
 * 最近同步成功的時間
 */
+ (NSDate *)lastSyncActionSuccessDate;


/**
 * 恢復成第一次同步的設定
 */
+ (void)resetToFirstSync;


/**
 * 當兩邊資料不一致時，開啟這個flag後再同步，可以強制重新比對
 */
+ (void)forceRecompareSync;
@end
