//
//  WCTRestClient+Subscribe.h
//  
//
//  Created by Howard on 2018/9/10.
//

#import "WCTRestClient.h"

// Model
#import "WCTRCSubscriptionInfoVoResponseResult.h"
#import "WCTRCRefreshSubscriptionInfoToServerResult.h"
#import "WCTRCGetAccountLimitResult.h"
#import "WCTRCGetSubscriptionURLResponseResult.h"

@interface WCTRestClient (Subscribe)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Subscribe Method

/**
 取得訂閱資訊

 @param loginToken 登入 token
 @param success 成功回傳
 @param failure 失敗回傳
 @return 訂閱資訊
 */
- (RKObjectRequestOperation *)subscriptionResponseResultWithLoginToken:(NSString *)loginToken
                                                       success:(void (^)(WCTRCSubscriptionInfoVoResponseResult *subscriptionInfoVoResponseResult))success
                                                       failure:(void (^)(NSError *error))failure;



/**
 更新訂閱資訊

 @param loginToken 登入 token
 @param success 成功回傳
 @param failure 失敗回傳
 @return 更新訂閱資訊結果
 */
- (RKObjectRequestOperation *)refreshSubscriptionInfoVoWithLoginToken:(NSString *)loginToken
                                                              success:(void (^)(WCTRCRefreshSubscriptionInfoToServerResult *refreshSubscriptionInfoToServerResult))success
                                                              failure:(void (^)(NSError *error))failure;


/**
 取得訂閱帳戶限制

 @param loginToken 登入token
 @param success 成功回傳
 @param failure 失敗回傳
 @return 訂閱帳戶列表
 */
- (RKObjectRequestOperation *)subscribedAccountLimitWithLoginToken:(NSString *)loginToken
                                                           success:(void (^)(WCTRCGetAccountLimitResult *accountLimitResult))success
                                                           failure:(void (^)(NSError *error))failure;



/**
 取得訂閱帳戶URL

 @param loginToken 登入token
 @param success 成功回傳
 @param failure 失敗回傳
 @return 訂閱帳戶限制
 */
- (RKObjectRequestOperation *)subscriptionURLWithLoginToken:(NSString *)loginToken
                                                    success:(void (^)(WCTRCGetSubscriptionURLResponseResult *subscriptionURLResponseResult))success
                                                    failure:(void (^)(NSError *error))failure;


/**
 試用帳號升級為6個月
 
 @param loginToken 登入token
 @param success 成功回傳
 @param failure 失敗回傳
 @return 訂閱帳戶限制
 */
- (RKObjectRequestOperation *)upgradeFromRetailWithLoginToken:(NSString *)loginToken
                                                      success:(void (^)(WCTRCBooleanResponseResult *responseResult))success
                                                      failure:(void (^)(NSError *error))failure;
@end
