//
//  WCTRestClient+Notice.h
//  Pods
//
//  Created by sanhue on 2016/8/17.
//
//

#import "WCTRestClient.h"

// response
#import "WCTRCNoticeListPageResponseResult.h"
#import "WCTRCNoticeListResponseResult.h"
#import "WCTRCLongResponseResult.h"
#import "WCTRCMessageResponseResult.h"

@interface WCTRestClient (Notice)

/**
 *  設定在這個時間之前的全部通知為已讀
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)setLastNoticeReadWithLoginToken:(NSString *)loginToken
                                                      success:(void (^)(WCTRCMessageResponseResult *lastNoticeReadResponseResult))success
                                                      failure:(void (^)(NSError *error))failure;

/**
 *  取得未讀通知的個數
 *
 *  @param loginToken 登入 Token
 *  @param noticeCategory 通知的分類
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)unreadNoticeWithLoginToken:(NSString *)loginToken
                                                noticeCategory:(NSString *)noticeCategory
                                                 success:(void (^)(WCTRCLongResponseResult *unreadNoticeResponseResult))success
                                                 failure:(void (^)(NSError *error))failure;


/**
 *  取得通知列表
 *
 *  @param loginToken 登入 Token
 *  @param noticeCategory 通知的分類
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)noticeListWithLoginToken:(NSString *)loginToken
                                        noticeCategory:(NSString *)noticeCategory
                                               success:(void (^)(WCTRCNoticeListResponseResult *noticeListResponseResult))success
                                               failure:(void (^)(NSError *error))failure;



/**
 *  取得通知列表(分頁)
 *
 *  @param loginToken 登入 Token
 *  @param noticeCategory 通知的分類 WCTRC_NoticeCategory
 *  @param noticeReadStatus 通知的狀態 WCTRC_NoticeReadStatus
 *  @param pageIndex 通知的頁次
 *  @param pageSize 一次取得幾個通知
 *  @param sortField 排序欄位 WCTRC_NoticeSortField_Type，WCTRC_NoticeSortField_Category，WCTRC_NoticeSortField_Time
 *  @param sortDirection 排序方向 WCTRC_NoticeSortDirection_ASC，WCTRC_NoticeSortDirection_DESC
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)noticeListPageWithLoginToken:(NSString *)loginToken
                                            noticeCategory:(NSString *)noticeCategory
                                          noticeReadStatus:(NSString *)noticeReadStatus
                                                 pageIndex:(NSInteger)pageIndex
                                                  pageSize:(NSInteger)pageSize
                                                 sortField:(NSString *)sortField
                                             sortDirection:(NSString *)sortDirection
                                                   success:(void (^)(WCTRCNoticeListPageResponseResult *noticeListPageResponseResult))success
                                                   failure:(void (^)(NSError *error))failure;


/**
 *  取得通知內文
 *
 *  @param loginToken 登入 Token
 *  @param noticeGuid 通知的分類
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)noticeContentWithLoginToken:(NSString *)loginToken
                                               noticeGuid:(NSString *)noticeGuid
                                                  success:(void (^)(WCTRCMessageResponseResult *noticeContentResponseResult))success
                                                  failure:(void (^)(NSError *error))failure;



/**
 發送聯絡人分享通知

 @param loginToken 登入 Token
 @param contacts 分享聯絡人
 @param accounts 接收帳號
 @param success 成功　回傳
 @param failure 失敗 回傳
 @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)noticeShareContactsToAccountsWithLoginToken:(NSString *)loginToken
                                                                 contacts:(NSArray *)contacts
                                                                 accounts:(NSArray *)accounts
                                                                  success:(void (^)(WCTRCMessageResponseResult *noticeContentResponseResult))success
                                                                  failure:(void (^)(NSError *error))failure;

@end
