//
//  WCTSharedContactNoticeViewController.h
//  Pods
//
//  Created by sanhue on 2016/9/12.
//
//

#import <UIKit/UIKit.h>
#import "WCTableViewController.h"
#import "WCTRCNoticeInfo.h"

@class WCTSharedContactNoticeViewController;
@protocol WCTSharedContactNoticeViewControllerDelegate <NSObject>
/**
 * 按下下載按鈕時回傳
 * @param sharedContactNoticeViewController instance of WCTSharedContactNoticeViewController
 * @param guids 要下載的guid
 */
- (void)sharedContactNoticeViewController:(WCTSharedContactNoticeViewController *)sharedContactNoticeViewController requestDownloadWithGuids:(NSArray *)guids;

@optional
- (NSString *)sharedContactNoticeViewController:(WCTSharedContactNoticeViewController *)sharedContactNoticeViewController requestErrorMessageWithError:(NSError *)error;

@end



////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTSharedContactNoticeViewController : WCTableViewController


/// delegate
@property (nonatomic, assign) id <WCTSharedContactNoticeViewControllerDelegate> delegate;

/// 指定title字串
@property (nonatomic, retain) NSString *titleString;

/// 帳號角色
@property (nonatomic, retain) NSString *accountRole;

/// 指定通知guid
@property (nonatomic, retain) WCTRCNoticeInfo *noticeInfo;

@end
