//
//  WCTLoginVIewController+ParameterDefine.h
//
//
//  Created by Howard on 2016/3/18.
//
//

#ifndef WCTLoginVIewController_ParameterDefine_h
#define WCTLoginVIewController_ParameterDefine_h

#import "NSError+Custom.h"

typedef NS_ENUM(NSInteger, WCTLoginViewControllerErrorCode)
{
    WCTLoginViewControllerErrorCode_None = 0,
    WCTLoginViewControllerErrorCode_CannotFindHost,
};

typedef NS_ENUM(NSInteger, WCTLoginViewControllerButtonTag)
{
    WCTLoginViewControllerButtonTag_Login = 1,
    WCTLoginViewControllerButtonTag_ReportProblem,
    WCTLoginViewControllerButtonTag_PasswordShow,
    WCTLoginViewControllerButtonTag_DropServerList,
    WCTLoginViewControllerButtonTag_ShowPassword,
    WCTLoginViewControllerButtonTag_HidePassword,
    WCTLoginViewControllerButtonTag_ForgetPassword,
    WCTLoginViewControllerButtonTag_DeviceID,
    WCTLoginViewControllerButtonTag_CreateAccount,
    WCTLoginViewControllerButtonTag_Manual,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCTLoginViewController_Section)
{
    WCTLoginViewController_Section_Login = 0,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCTLoginViewController_Section_Login_Row)
{
    WCTLoginViewController_Section_Login_Row_Server,
    WCTLoginViewController_Section_Login_Row_ProtocolAndPort,
    WCTLoginViewController_Section_Login_Row_User,
    WCTLoginViewController_Section_Login_Row_Password,
    WCTLoginViewController_Section_Login_Row_AutoLogin,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSInteger, WCTLoginViewControllerAlertViewTag)
{
    WCTLoginViewControllerAlertViewTag_WarningOfflineMode = 1,
    WCTLoginViewControllerAlertViewTag_WarningSwitchServer,
    WCTLoginViewControllerAlertViewTag_WarningSwitchUser,
    WCTLoginViewControllerAlertViewTag_WarningSwitchHttp,
    WCTLoginViewControllerAlertViewTag_ReportMail,
    WCTLoginViewControllerAlertViewTag_WarningLeft2WeekOfDate,
    WCTLoginViewControllerAlertViewTag_WarningOutOfDate,
};





////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSInteger, WCTLoginViewControllerTableViewTag)
{
    WCTLoginViewControllerTableViewTag_LoginForm,
    WCTLoginViewControllerTableViewTag_ServerList,
};





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - TextField Tag Define

typedef NS_ENUM(NSInteger, WCTLoginViewControllerTextFieldTag)
{
    WCTLoginViewControllerTextFieldTag_Protocol = 100,
    WCTLoginViewControllerTextFieldTag_Port,
    WCTLoginViewControllerTextFieldTag_URL,
};





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - TextField Tag Define

typedef NS_ENUM(NSInteger, WCTLoginViewControllerSelectionControllerTag)
{
    WCTLoginViewControllerSelectionControllerTag_ServerList = 100,
    WCTLoginViewControllerSelectionControllerTag_Protocol
};





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Port Define

static NSUInteger  const WCTLVC_HttpPort  = 9080;
static NSUInteger  const WCTLVC_HttpsPort  = 9443;

static NSUInteger  const WCTLVC_PublicCloudHttpPort  = 80;
static NSUInteger  const WCTLVC_PublicCloudHttpsPort  = 443;


#endif /* WCTLoginVIewController_ParameterDefine_h */
