//
//  WCTAccountFlowController.h
//  Pods
//
//  Created by AndrewLai on 2016/5/5.
//
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, WCTAccountFlowErrorCode)
{
    WCTAccountFlowErrorCode_None = 0,
    WCTAccountFlowErrorCode_ChangeNameFailed,
    WCTAccountFlowErrorCode_ChangePasswordFailed,
};

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - WCTAccountFlowControllerDelegate

@class WCTAccountFlowController;
@protocol WCTAccountFlowControllerDelegate <NSObject>

- (void)accountFlowControllerWillLogoutAccount:(WCTAccountFlowController *)accountFlowController;
- (void)accountFlowControllerWillDismissViewController:(WCTAccountFlowController *)accountFlowController;

@optional
- (NSString *)accountFlowController:(WCTAccountFlowController *)accountFlowController requestErrorMessageWithError:(NSError *)error;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - WCTAccountFlowController Interface

@interface WCTAccountFlowController : NSObject

@property (nonatomic, assign) id<WCTAccountFlowControllerDelegate> delegate;

- (void)showFromSuperViewController:(UIViewController *)superViewController;

@end
