//
//  WCSearchViewController.h
//
//
//  Created by sanhue on 2015/7/9.
//  Copyright (c) 2015年 penpower. All rights reserved.
//

#import "WCTableViewController.h"

#import "PPNavigationBarView.h"
#import "PPSearchBar.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@class WCSearchViewController;

@protocol WCSearchViewControllerDelegate <NSObject>


/**
 * 用來取得cache中的縮圖
 * @param searchViewController viewcontroller的實體
 * @param cardID 要取得的名片圖的名片ID
 * @return UIImage 名片圖縮圖
 */
- (UIImage *)searchViewController:(WCSearchViewController *)searchViewController cachedThumbnailImageWithCardID:(NSString *)cardID;


/**
 * 用來取得cell中的縮圖
 * @param searchViewController viewcontroller的實體
 * @param cardID 要取得的名片圖的名片ID
 * @return UIImage 名片圖縮圖
 */
- (UIImage *)searchViewController:(WCSearchViewController *)searchViewController thumbnailImageWithCardID:(NSString *)cardID;

/**
 * 搜尋的結果
 * @param searchText 要搜尋的字串
 * @return NSMutableArray 回傳所取得的資料, 以WCCardSectionModel組成的array
 */
- (NSMutableArray *)copyCardsWithSearchText:(NSString *)searchText;

@optional
/**
 * 按下勾選按鈕
 * @param searchViewController view controller 的實體
 */
- (void)didClickMultiSelectWithSearchViewController:(WCSearchViewController *)searchViewController;


/**
 * 按下進階搜尋按鈕
 * @param searchViewController view controller 的實體
 */
- (void)didClickAdvanceSearchWithSearchViewController:(WCSearchViewController *)searchViewController;

/**
 * 選擇某一個cell
 * @param searchViewController view controller 的實體
 * @param cardID 點選的cell對應到的cardID
 */
- (void)searchViewController:(WCSearchViewController *)searchViewController didSelectCardID:(NSString *)cardID;


/**
 * 取得目前搜尋的類別名稱
 * @param searchViewController view controller 的實體
 */
- (NSString *)groupNameForSearchViewController:(WCSearchViewController *)searchViewController;

/**
 *  結束搜尋
 *
 *  @param searchViewController 委託者
 *  @param keyword              關鍵字
 */
- (void)searchViewController:(WCSearchViewController *)searchViewController didEndSearchWithKeyword:(NSString *)keyword;


/**
 *  回傳是否刷新資料 when ViewWillAppear
 *
 *  @return YES，要重新
 */
- (BOOL)reloadTableViewDataWhenViewWillAppear;

#pragma mark Advance Search Delegate
/**
 * 要求進階搜尋
 * @param searchOptionModels 進階搜尋條件
 * @return NSMutableArray 回傳所取得的資料, 以WCCardSectionModel組成的array
 */
- (NSMutableArray *)copyCardsWithAdvanceSearchOptionModels:(NSArray *)searchOptionModels;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCSearchViewController : WCTableViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic, assign) id<WCSearchViewControllerDelegate> delegate;

@property (nonatomic, retain, readonly) PPNavigationBarView *ppNavigationBarView;
@property (nonatomic, retain, readonly) PPButton *ppButtonAdvanceSearch;
@property (nonatomic, retain, readonly) PPButton *ppButtonMultiSelect;
@property (nonatomic, retain, readonly) PPButton *ppButtonCancel;
@property (nonatomic, retain, readonly) PPSearchBar *searchBar;

#pragma mark - Advance Search
/// 是否顯示進階搜尋，預設NO
@property (nonatomic, assign) BOOL showAdvanceSearch;

/// 執行進階搜尋
- (void)searchWithOptionModels:(NSArray *)optionModels;

@end

