//
//  WCPromotionADController.h
//  WorldCardMobile7
//
//  Created by sanhue on 2015/10/22.
//  Copyright © 2015年 penpower. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface WCPromotionADController : NSObject

/**
 * phone kit promotion
 * @param viewController promotion will show from view controller
 * @param force force show promotion, else show if value of WCMSC_IV_kHasShownPromotion is 0
 */
+ (void)showPhoneKitPromotionFromViewController:(UIViewController *)viewController force:(BOOL)force;

/**
 * 顯示台灣地區顯示purchase, 其他地區顯示promotion
 * @param viewController promotion will show from view controller
 * @param force force show promotion, else show if value of WCMSC_IV_kHasShownPromotion is 0
 */
+ (void)showPromotionFromViewController:(UIViewController *)viewController force:(BOOL)force;

/**
 * 依URL顯示廣告頁
 * @param viewController promotion will show from view controller
 * @param force force show promotion, else show if value of WCMSC_IV_kHasShownPromotion is 0
 */
+ (void)showPromotionByURLFromViewController:(UIViewController *)viewController force:(BOOL)force;


/**
 * 暫停promotion顯示，設定後就秀不出來，但已經秀的不會關閉
 */
+ (void)supendShowPromotion;

/**
 * 回復promotion顯示，設定後就可以秀，但call完不會馬上秀，要等|showPromotionFromViewController:force:|執行才會秀
 */
+ (void)resumeShowPromotion;

@end
