//
//  WCMultiSelectViewController.h
//  WorldCardMobile7
//
//  Created by sanhue on 2015/7/9.
//  Modified by Andrew on 2016/3/23.
//  Copyright (c) 2015年 penpower. All rights reserved.
//

#import "WCTableViewController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@class WCMultiSelectViewController;
@protocol WCMultiSelectViewControllerDelegate <NSObject>

/**
 * 用來取得cache中的縮圖
 * @param wcMultiSelectViewController viewcontroller的實體
 * @param cardID 要取得的名片圖的名片ID
 * @return UIImage 名片圖縮圖
 */
- (UIImage *)wcMultiSelectViewController:(WCMultiSelectViewController *)wcMultiSelectViewController cachedThumbnailImageWithCardID:(NSString *)cardID;


/**
 * 用來取得cell中的縮圖
 * @param wcMultiSelectViewController viewcontroller的實體
 * @param cardID 要取得的名片圖的名片ID
 * @return UIImage 名片圖縮圖
 */
- (UIImage *)wcMultiSelectViewController:(WCMultiSelectViewController *)wcMultiSelectViewController thumbnailImageWithCardID:(NSString *)cardID;


/**
 *  當選取變更或初始化時，需通知外部選取了幾筆聯絡人
 *
 *  @param wcMultiSelectViewController viewcontroller的實體
 *  @param selectedContactCount                已選取的聯絡人數量
 */
- (void)wcMultiSelectViewController:(WCMultiSelectViewController *)wcMultiSelectViewController selectedContactChangeWithCount:(NSUInteger)selectedContactCount;


#pragma mark - UI Resource

/**
 *  要求外部給予下方工具列的按鈕清單
 *  @param wcMultiSelectViewController viewcontroller的實體
 *  @return NSArray array of PPButton
 */
- (NSArray *)bottomToolBarButtonArrayInWCMultiSelectViewController:(WCMultiSelectViewController *)wcMultiSelectViewController;


#pragma mark - Guide Show Notify

/**
 *  通知外部可以呈現Guide的時機點
 *
 *  @param wcMultiSelectViewController viewcontroller的實體
 */
- (void)wcMultiSelectViewControllerShowGuideIfNeeded:(WCMultiSelectViewController *)wcMultiSelectViewController;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCMultiSelectViewController : WCTableViewController
@property (nonatomic, retain) id<WCMultiSelectViewControllerDelegate> delegate;
@property (nonatomic, retain) NSString *navigationBarTitleString;
@end
