//
//  WCMapViewController+ParameterDefine.h
//
//
//  Created by Howard on 2015/12/29.
//
//

#ifndef WCMapViewController_ParameterDefine_h
#define WCMapViewController_ParameterDefine_h

//////////////////////////////////////////////////

static CGFloat const DefaultMapCenterDistanceKiloMeterThreshold = 300;
static CGSize  const DefaultMapRegionSize = {1000,1000};

//////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCMapViewControllerActionSheetTag)
{
    WCMapViewControllerActionSheetTag_MapSelect,
    WCMapViewControllerActionSheetTag_ContactSelect,
};

//////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCMapViewControllerMode)
{
    WCMapViewControllerMode_Apple,
    WCMapViewControllerMode_Google,
    WCMapViewControllerMode_Baidu,
};

//////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCMapViewControllerButtonTag)
{
    WCMapViewControllerButtonTag_Back,
    WCMapViewControllerButtonTag_Location,
    WCMapViewControllerButtonTag_Home,
    WCMapViewControllerButtonTag_Navigation,
};

//////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCMapViewControllerDistanceStyle)
{
    WCMapViewControllerDistanceStyle_KiloMeter, //公里顯示
    WCMapViewControllerDistanceStyle_Mile, //英哩顯示
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notificatoin Name Define

static NSString * const WCMapViewControllerRenewAnnotationsNotification = @"WCMapViewControllerRenewAnnotationsNotification";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notification UserInfo Key

//結果
static NSString * const WCMapViewControllerUserInfoKey_Annotations = @"WCMapViewControllerUserInfoKey_Annotations";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notification Obtain Visible Range

static NSString * const WCMapViewController_ObtainVisibleRange = @"WCMapViewController_ObtainVisibleRange";
static NSString * const WCMapViewController_ObtainNoVisibleRange = @"WCMapViewController_ObtainNoVisibleRange";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Unit Transform

static CGFloat const WCMapViewController_MIPerKiloMeter = 0.621;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Timeout count

static NSUInteger  const WCMapViewController_DefaultAllowTimeOutCount  = 5;



#endif /* WCMapViewController_ParameterDefine_h */
