//
//  CategoryTableViewCell.h
//  WorldNote
//
//  Created by Andrew.Lai on 14/3/20.
//  Copyright (c) 2014年 Eddie. All rights reserved.
//

#import "PPTableViewCell.h"
#import "PPCheckBoxView.h"
#import "PPButton.h"

// 排版為|PinMark|CheckBox|Name|CardCount|expandButton|
// Name是一定會有，expandButton有subgroup時會有，可由reserveSpaceWhenExpandButtonHidden設定沒有expandbutton時要不要保留空間



////////////////////////////////////////////////////////////////////////////////////////////////////

#define MaximumContentCount 88888

typedef NS_ENUM(NSInteger, WCGroupTableViewCellStyleMask)
{
    WCGroupTableViewCellStyleMask_None          = 0,            ///<預設排序，只有Name, ExpandButton
    WCGroupTableViewCellStyleMask_CardCount     = 1 << 0,       ///< cardCount
    WCGroupTableViewCellStyleMask_PinButton     = 1 << 1,       ///< PinMark
    WCGroupTableViewCellStyleMask_CheckBox      = 1 << 2,       ///< checkBox
};

@class WCGroupTableViewCell;
@protocol WCGroupTableViewCellDelegate <NSObject>
@optional

/**
 * 通知勾選cell
 * @param cell 被點選的cell
 */
- (void)didCheckCell:(WCGroupTableViewCell *)cell;

/**
 * 按下展開鈕
 * @param cell 被點選的cell
 */
- (void)didClickExpandWithCell:(WCGroupTableViewCell *)cell;


/**
 * 通知釘選群組，style是WCGroupTableViewCellStyle_NameWithCountAndPinMark時才會傳出
 * @param cell 被點選的cell
 * @param isPinned 是否要釘選
 */
- (void)cell:(WCGroupTableViewCell *)cell isPinned:(BOOL)isPinned;

@end
////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCGroupTableViewCell : PPTableViewCell

@property (nonatomic, assign) id<WCGroupTableViewCellDelegate> delegate;

@property (nonatomic, assign) UIEdgeInsets edgeInsets;
@property (nonatomic, assign) WCGroupTableViewCellStyleMask cellStyleMask;  ///< default WCGroupTableViewCellStyleMask_None

/// 不顯示展開按鈕時，是否保留按尋空間，預設NO，表示不保留
@property (nonatomic, assign) BOOL reserveSpaceWhenExpandButtonHidden;

/// disable long press cell when styleMask containt WCGroupTableViewCellStyleMask_PinButton, default NO
@property (nonatomic, assign) BOOL enableLongPressCell;

@property (nonatomic, assign) NSInteger level;
@property (nonatomic, retain, readonly) UILabel *nameLabel;
@property (nonatomic, retain, readonly) UILabel *cardCountLabel;
@property (nonatomic, retain, readonly) PPButton *pinMarkButton;
@property (nonatomic, retain, readonly) PPButton *expandButton;
@property (nonatomic, retain, readonly) PPCheckBoxView *checkBoxView;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (void)setCardCount:(NSUInteger)cardCount;
- (void)setPinMark:(BOOL)isMarked;
- (void)setCheckBoxViewStatus:(BOOL)isSelected;
- (void)setCellExpanded:(BOOL)expanded;
- (void)setExpandButtonHidden:(BOOL)hidden;


@end
