//
//  WCGroupFlowController.h
//  ADAL
//
//  Created by sanhue on 2018/3/5.
//

#import <Foundation/Foundation.h>
#import "WCSingleLayerGroupViewController.h"
#import "WCGroupAccessFlowControllerDelegate.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCGroupAccessFlowController : NSObject

@property (nonatomic, assign) id<WCGroupAccessFlowControllerDelegate> delegate;
@property (nonatomic, retain) id userInfo;

+ (instancetype)sharedInstance;

#pragma  mark for WCM
/// 顯示WCM編輯介面
- (void)showWCMGroupEditViewControllerFromViewController:(UIViewController *)viewController;

/// 顯示變更類別
- (void)showWCMChangeGroupViewControllerFromViewController:(UIViewController *)viewController;

#pragma mark for WCT
/// 顯示釘選編輯
- (void)showPinnedGroupEditViewControllerFromViewController:(UIViewController *)viewController;

/// 顯示多層類別編輯
- (void)showMultiLayerGroupEditViewControllerFromViewController:(UIViewController *)viewController;

/// 顯示變更類別 (使用showMultiSelectGroupViewControllerFromViewController，titleString:WCGAFC_MLS_ChangeGroup)
- (void)showChangeGroupViewControllerFromViewController:(UIViewController *)viewController;

/**
 * 顯示多選選單並指定TitleString
 * @param viewController 要從哪邊present
 * @param titleString title string
 * @param forcePresent 強制使用新的NavigationController present
 */
- (void)showMultiSelectGroupViewControllerFromViewController:(UIViewController *)viewController titleString:(NSString *)titleString forcePresent:(BOOL)forcePresent;

/**
 * 顯示單選選單並指定TitleString
 * @param viewController 要從哪邊present
 * @param titleString title string
 * @param forcePresent 強制使用新的NavigationController present
 */
- (void)showSingleSelectGroupSelectViewControllerFromViewController:(UIViewController *)viewController titleString:(NSString *)titleString forcePresent:(BOOL)forcePresent;


@end
