//
//  WCFieldTypeConverter.h
//  
//
//  Created by sanhue on 2014/10/16.
//
//

#import <Foundation/Foundation.h>
#import "WCFieldDefine.h"
#import "WCImageDefine.h"

#import <PPContactMainTypeDefine.h>
#import <PPContactSubTypeDefine.h>
#import <PPContactLabelTypeDefine.h>
#import <PPContactLabelTextDefine.h>
#import <PPContactFieldSourceDefine.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

#define EditCustomGroupType 3999

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCFieldTypeConverter : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCFieldType from PPContactViewController type

+ (WC_FieldSource)fieldSourceFromPPContactFieldSource:(PPContactFieldSource)fieldSource;
+ (WC_FieldType)fieldTypeFromPPContactMainType:(PPContactMainType)type;
+ (WC_FieldSubType1)fieldSubType1FromPPContactLabelType:(PPContactLabelType)type;
+ (WC_FieldSubType1)fieldSubType1WithPPContactLabelTextString:(NSString *)subTypeString mainType:(PPContactMainType)type;
+ (WC_FieldSubType2)fieldSubType2FromPPContactSubType:(PPContactSubType)subType;
+ (WC_ImageType)imageTypeFromPPContactMainType:(PPContactMainType)type;

/// for salesforce field
+ (WC_FieldSubType2)fieldSubType2FromPPContactLabelType:(PPContactLabelType)type;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark -  PPContactViewController type from WCFieldType

+ (PPContactFieldSource)contactFieldSourceFromFieldSource:(WC_FieldSource)fieldSource;
+ (PPContactMainType)contactMainTypeFromFieldType:(WC_FieldType)fieldType dateAsBirthday:(BOOL)dateAsBirthday;
+ (PPContactLabelType)contactLabelTypeFromFieldSubType1:(WC_FieldSubType1)fieldSubType1;
+ (PPContactSubType)contactSubTypeFromFieldSubType2:(WC_FieldSubType2)fieldSubType2;
+ (NSString *)subTypeStringWithFieldType:(WC_FieldType)type associateType:(WC_FieldSubType1)associateType;


/// for salesforce
+ (PPContactLabelType)contactLabelTypeFromFieldSubType2:(WC_FieldSubType2)fieldSubType2;
+ (NSString *)subTypeStringWithFieldSubType2:(WC_FieldSubType2)fieldSubType2;

@end
