//
//  WCDuplicateCompareModel.h
//  WorldCardMobile
//
//  Created by  Eddie on 12/7/19.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "WCCardModel.h"

@interface WCDuplicateCheckNameModel : NSObject

@property (nonatomic, retain) NSString *cardID;
@property (nonatomic, retain) NSString *name;
@property (nonatomic, retain) NSString *allFieldValueString;

+ (id)copyNameModelWithCardID:(NSString *)cardID name:(NSString *)name;

@end


@interface WCDuplicateCompareModel : NSObject
{
    NSMutableArray *nameArray_;        // array of WCDuplicateCheckNameModel
    NSMutableDictionary *restFieldDict_;
    // restFieldDict_ - key : cardID
    //                  value : mutable dict - key : WC_FieldType
    //                                         value : mutable set of field value
    //

}

@property (nonatomic, readonly) NSMutableArray *nameArray;
@property (nonatomic, readonly) NSMutableDictionary *restFieldDict;

- (BOOL)hasSameCardID:(NSString *)cardID;

- (NSMutableArray *)copySameNameCardIDArrayWithCheckNameModel:(WCDuplicateCheckNameModel *)checkNameModel
                                       checkFieldValueSetDict:(NSMutableDictionary *)checkFieldValueSetDict
                                               findStartIndex:(BOOL)findStartIndex;

- (NSMutableArray *)copyDuplicateCardIDArrayWithCheckNameModel:(WCDuplicateCheckNameModel *)checkNameModel
                                        checkFieldValueSetDict:(NSMutableDictionary *)checkFieldValueSetDict
                                                findStartIndex:(BOOL)findStartIndex;

- (void)getDuplicateCheckNameArray:(NSMutableArray *)checkNameArray
            checkFieldValueSetDict:(NSMutableDictionary *)checkFieldValueSetDict
                     fromCardModel:(WCCardModel *)cardModel;

- (NSInteger)indexWithFirstSameName:(WCDuplicateCheckNameModel *)nameModel;
- (void)removeDataWithCardID:(NSString *)cardID;
- (void)addDataWithNameArray:(NSArray *)nameArray fieldValueSetDict:(NSMutableDictionary *)fieldValueSetDict;

/// 檢查這個名片的其他欄位資料是否是空的
- (BOOL)isRestFieldEmpty:(NSString *)cardID;
@end
