//
//  WCSettingsKey.h
//  Pods
//
//  Created by sanhue on 2016/8/9.
//
//

#ifndef WCSettingsKey_h
#define WCSettingsKey_h

#define WCSC_IV_kIsFirstTimeLaunch       @"WCSC_IV_kIsFirstTimeLaunch"           // Yes(1) or No(0)
#define WCSC_IV_kSectionIndexMode        @"WCSC_IV_kSectionIndexMode"            // PPSIC_Mode, default PPSIC_M_English
#define WCSC_IV_kEasternNameOrder        @"WCSC_IV_kEasternNameOrder"            // WCDisplayNameOrder
#define WCSC_IV_kWesternNameOrder        @"WCSC_IV_kWesternNameOrder"            // WCDisplayNameOrder
#define WCSC_IV_kSortingByField          @"WCSC_IV_kSortingByField"              // WC_SortedByField
#define WCSC_SV_kAppVersion              @"WCSC_SV_kAppVersion"



////////////////////////////////////////////////////////////////////////////////////////////////////
// WCM 7.0.0 新增

///用來儲存cardHolder目前的group設定
#define WCSC_IV_kTargetGroupID              @"WCSC_IV_kTargetGroupID"               // WC_GroupID  目前CardHolder顯示的group
#define WCSC_IV_kEnableSaveToiPhone         @"WCSC_IV_kEnableSaveToiPhone"          // Yes(1) or No(0)
#define WCSC_SV_kSaveToiPhoneSourceID       @"WCSC_SV_kSaveToiPhoneSourceID"        // Source (NSString)
#define WCSC_SV_kSaveToiPhoneGroupID        @"WCSC_SV_kSaveToiPhoneGroupID"         // Group (NSString)

/// 辨識名片時是否要自動格式化電話號碼，這個設定有開啟，才會使用自動加入國碼，預設開啟
#define WCSC_IV_kAutoFormatPhoneNumber      @"WCSC_IV_kAutoFormatPhoneNumber"
#define WCSC_IV_kRecognPhoneCountryCode     @"WCSC_IV_kRecognPhoneCountryCode"



////////////////////////////////////////////////////////////////////////////////////////////////////
// WCM 7.1.0 新增

/// 附近聯絡人顯示距離單位的設定值
/// value : <0, 公里；1, 英哩, 預設為0>
#define WCSC_IV_kNearByContactsMeasureUnit  @"WCSC_IV_kNearByContactsMeasureUnit"

/// 記錄上次更新DisplayRule的時間
/// value : <Time interveral since reference date>
#define WCSC_IV_kLastUpdateDisplayRuleTime  @"WCSC_IV_kLastUpdateDisplayRuleTime"

/// 記錄資料庫是否已根據display rule更新
/// value : <YES(1), 不用再再更新資料庫., NO(0)，要再更新資料庫>
#define WCSC_IV_kIsDBUpdatedDisplayRuleData @"WCSC_IV_kIsDBUpdatedDisplayRuleData"

/// 記錄類別順序修改時間，只有透過app介面手動修改才要記錄
/// value : <Time interveral since reference date>
#define WCSC_IV_kCategoryOrderModifiedTime  @"WCSC_IV_kCategoryOrderModifiedTime"

/// 是否已顯示過promotion
#define WCSC_IV_kHasShownPromotion          @"WCSC_IV_kHasShownPromotion"

/// 廣告頁的連結
#define WCSC_SV_PromotionURL                @"WCSC_SV_PromotionURL"

/// 廣告頁的ID（日期字串）
#define WCSC_SV_kPromotionID                @"WCSC_SV_kPromotionID"

/// 是否開啟廣告頁功能，(優惠活動也要看這個值決定要不要顯示ITEM)
#define WCSC_IV_kEnablePromotion                @"WCSC_IV_kEnablePromotion"

/// 之前同步登入的google帳號
#define WCSC_IV_kPreviousGoogleAccount      @"WCSC_IV_kPreviousGoogleAccount"

/// 自動同步的網路來源
/// value : <0: Wifi only, 1: Wifi+3G, 2: close>
#define WCSC_IV_kSyncNetWorkSource          @"WCSC_IV_kSyncNetWorkSource"

typedef NS_ENUM(NSUInteger, WCSyncNetWorkSource)
{
    WCSyncNetWorkSource_WifiOnly = 0,
    WCSyncNetWorkSource_WifiAnd4G,
    WCSyncNetWorkSource_None,
};

/// 最後同步的時間 (只有team在用了)
/// value : <Time interveral since reference date>
#define WCSC_IV_kLastSyncTime               @"WCSC_IV_kLastSyncTime"

////////////////////////////////////////////////////////////////////////////////////////////////////
// WCT 1.8 新增
#define WCSC_IV_kShowEditAfterRecognition @"WCSC_IV_kShowEditAfterRecognition"

#define WCSC_IV_kShowNoteAfterRecognition @"WCSC_IV_kShowNoteAfterRecognition"

////////////////////////////////////////////////////////////////////////////////////////////////////
// WCT 1.0.0 (WCTMAC 1.0.0) 新增

/// 辨識輸出字集
typedef NS_ENUM(NSUInteger, WCSCChineseOutputLangSet)
{
    WCSCChineseOutputLangSet_AsRecognized = 0,
    WCSCChineseOutputLangSet_ConvertToCHS,
    WCSCChineseOutputLangSet_ConvertToCHT,
};

/// 中文辨識輸出字集
/// value: <WCSCChineseOutputLangSet>
#define WCSC_IV_kRecogChineseOutputLangSet  @"WCSC_IV_kRecogChineseOutputLangSet"

/// 辨識結果首字大寫
#define WCSC_IV_kCapitalizeRecogResult  @"WCSC_IV_kCapitalizeRecogResult"

/// 地圖引擎
typedef NS_ENUM(NSUInteger, WCSCMapEngine)
{
    WCSCMapEngine_Auto = 0,
    WCSCMapEngine_GoogleMap,
    WCSCMapEngine_BaiduMap
};

/// 使用者的地圖引擎
/// value: <WCSCMapEngine>
static NSString * const WCSC_IV_UserMapEngine = @"WCSC_IV_UserMapEngine";

////////////////////////////////////////////////////////////////////////////////////////////////////
// 提醒相關設定值

// 記錄最後一次提醒通知的更新時間
static NSString *const WCSC_IV_ReminderNotificationLastUpdateTime = @"WCSC_IV_ReminderNotificationLastUpdateTime";

typedef NS_ENUM(NSInteger, WCSCReminderType)
{
    WCSCReminderType_Backup = 0,                  // 備份提醒
    WCSCReminderType_ContactNewContacts,          // 聯絡新增聯絡人提醒
    WCSCReminderType_Anniversary,                 // 紀念日提醒
    WCSCReminderType_Birthday,                    // 生日提醒
};

typedef NS_ENUM(NSInteger, WCSCBackupReminderSettings)
{
    WCSCBackupReminderSettings_Never = 0,
    WCSCBackupReminderSettings_AWeek,
    WCSCBackupReminderSettings_TwoWeeks,
    WCSCBackupReminderSettings_AMonth,
};


/// 備份提醒設定值，value: <WCSCBackupReminderSettings>
static NSString *const WCSC_IV_BackupReminder = @"WCSC_IV_BackupReminder";

typedef NS_ENUM(NSInteger, WCSCContactNewContactReminderSettings)
{
    WCSCContactNewContactReminderSettings_Never = 0,
    WCSCContactNewContactReminderSettings_AfterOneDay,
    WCSCContactNewContactReminderSettings_AfterTwoDays,
    WCSCContactNewContactReminderSettings_AfterAWeek,
};

/// 聯絡新增聯絡人提醒設定值，value: <WCSCContactNewContactReminderSettings>
static NSString *const WCSC_IV_ContactnewContactsReminder = @"WCSC_IV_ContactnewContactsReminder";


typedef NS_ENUM(NSInteger, WCSCAnniversaryReminderSettings)
{
    WCSCAnniversaryReminderSettings_Never = 0,
    WCSCAnniversaryReminderSettings_BeforeOneDay,
    WCSCAnniversaryReminderSettings_BeforeTwoDays,
    WCSCAnniversaryReminderSettings_BeforeAWeek,
};

/// 生日/紀念日提醒設定值，value: <WCSCAnniversaryReminderSettings>
static NSString *const WCSC_IV_AnniversaryReminder = @"WCSC_IV_AnniversaryReminder";


////////////////////////////////////////////////////////////////////////////////////////////////////
// WCMAC 4.0.0 新增

/// 目前使用的資料庫名稱 (mac版使用)
static NSString * const WCSC_SV_DatabaseName = @"WCSC_SV_DatabaseName";

////////////////////////////////////////////////////////////////////////////////////////////////////
// deprecate
#define WCSC_IV_kSaveToiPhoneSourceID       @"WCSC_IV_kSaveToiPhoneSourceID"        // Source ABRecordID
#define WCSC_IV_kSaveToiPhoneGroupID        @"WCSC_IV_kSaveToiPhoneGroupID"         // Group ABRecordID


#endif /* WCSettingsKey_h */
