//
//  WCSearchOptionModel.h
//  Extension
//
//  Created by sanhue on 2018/10/22.
//

#import <Foundation/Foundation.h>
#import "WCFieldDefine.h"

NS_ASSUME_NONNULL_BEGIN

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSInteger, WCSearchOperator)
{
    WCSearchOperator_OR =0,
    WCSearchOperator_AND,
};

typedef NS_ENUM(NSInteger, WCSearchType)
{
    WCSearchType_Name = WC_FT_Name,                // 還要包含暱稱
    WCSearchType_Address = WC_FT_Address,
    WCSearchType_Phone = WC_FT_Phone,
    WCSearchType_Email = WC_FT_Email,
    WCSearchType_URL = WC_FT_URL,
    WCSearchType_InstantMessage = WC_FT_InstantMessage,
    WCSearchType_Note = WC_FT_Note,
    WCSearchType_UnifiedBusinessNo = WC_FT_UnifiedBusinessNo,
    WCSearchType_SocialNetwork = WC_FT_SocialNetwork,
    WCSearchType_UserDefine = WC_FT_UserDefine, ///< 這個在自訂欄位section
    
    WCSearchType_Company = WC_FST2_Company_Name,
    WCSearchType_Department= WC_FST2_Company_Department,
    WCSearchType_JobTitle = WC_FST2_Company_JobTitle,
    
    
    WCSearchType_Birthday = WC_FST1_Date_Birthday, ///< 這個在日期section
    WCSearchType_Anniversary = WC_FST1_Date_Anniversary, ///< 這個在日期section
    
    WCSearchType_CreateTime  = 10000,      /// main type有可能到十位數，所以這邊從10000開始
    WCSearchType_ModifiedTime,
    
    WCSearchType_Group  = 11000, ///< 這個在類別section
    
    WCSearchType_Custom = 12000, ///< 客制的SearchType從這邊開始
//    WCSearchType_Owner = 12000,
//    WCSearchType_Creator,
//    WCSearchType_Editor,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - constructor methods
@protocol WCSearchOptionModel_Constructor <NSObject>

+ (instancetype)searchOptionModelForAND;
+ (instancetype)searchOptionModelForOR;


@end


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCSearchOptionModel : NSObject <NSCopying, WCSearchOptionModel_Constructor>
@property (nonatomic, assign) WCSearchOperator searchOperator;
@property (nonatomic, assign) WCSearchType searchType;
@property (nonatomic, retain, nullable) NSString *text;     ///< 文字，數字欄位都是; WCSearchType_Group, WCSearchType_Owner, WCSearchType_Creator, WCSearchType_Editor用來放顯示名稱

#pragma mark - date property
@property (nonatomic, retain, nullable) NSDate *fromDate;  ///< WCSearchType_Birthday, WCSearchType_Anniversary, WCSearchType_CreateTime, WCSearchType_ModifiedTime, 日期樣式的自訂欄位使用
@property (nonatomic, retain, nullable) NSDate *toDate;    ///< WCSearchType_Birthday, WCSearchType_Anniversary, WCSearchType_CreateTime, WCSearchType_ModifiedTime, 日期樣式的自訂欄位使用

#pragma mark - category property
@property (nonatomic, retain, nullable) NSMutableArray *groupGuids;          ///< WCSearchType_Group使用, 存放array of group guid

#pragma mark - account property
@property (nonatomic, retain, nullable) NSMutableArray *accountGuids;        ///< WCSearchType_Owner, WCSearchType_Creator, WCSearchType_Editor使用, 存放array of account guid

#pragma mark - customfield property
@property (nonatomic, retain, nullable) NSString *customFieldID;      ///< WCSearchType_UserDefine使用, 記錄要搜尋的自訂欄位的guid
@property (nonatomic, assign) NSInteger customFieldType;      ///< WCSearchType_UserDefine使用, 記錄要搜尋的自訂欄位的contentType
@property (nonatomic, retain, nullable) NSString *customFieldValue;   ///< WCSearchType_UserDefine使用，文字樣式的自訂欄位
@property (nonatomic, retain, nullable) NSMutableArray *customFieldListItemIDs; ///< WCSearchType_UserDefine使用, 選單樣式的自訂欄位, 存放array of customField guid
@property (nonatomic, retain, nullable) NSString *customFieldValueFrom;   ///< WCSearchType_UserDefine使用，數值樣式的自訂欄位
@property (nonatomic, retain, nullable) NSString *customFieldValueTo;   ///< WCSearchType_UserDefine使用，數值樣式的自訂欄位

#pragma mark - Utility methods

+ (WCSearchType)searchTypeFromFieldType:(WC_FieldType)FieldType;
+ (WCSearchType)searchTypeFromFieldSubType1:(WC_FieldSubType1)subType1;
+ (WCSearchType)searchTypeFromFieldSubType2:(WC_FieldSubType2)subType2;
@end

NS_ASSUME_NONNULL_END
