//
//  WCCardImageDefine.h
//  WorldCard series
//
//  Created by  Eddie on 2012/3/22.
//  Copyright 2011 Penpower. All rights reserved.
//

#import "CrossPlatformDefine.h"

#ifndef WorldCard_WCImageDefine_h
#define WorldCard_WCImageDefine_h

////////////////////////////////////////////////////////////////////////////////////////////////////
// jpg壓縮率

#define WC_JPG_COMPRESS                 0.1
#define WC_JPG_SilentRecognCompress     0.7
#define WC_JPG_MaxCompress              0.9     // 注意壓縮比設定1是沒用的，只是會讓檔案變大。


////////////////////////////////////////////////////////////////////////////////////////////////////
// image file suffix definition 

#define WC_IFS_IDPhoto		@"id"
#define WC_IFS_FrontSide	@"fs"
#define WC_IFS_BackSide		@"bs"

#define WC_IFS_ReRecogn		@"r"
#define WC_IFS_Original		@"o"
#define WC_IFS_Browse		@"b"
#define WC_IFS_Thumbnail	@"t"


////////////////////////////////////////////////////////////////////////////////////////////////////
// image max size definition 
#define WC_IMS_ReRecogn		1600
#define WC_IMS_Original		1600
#define WC_IMS_Browse		720
#define WC_IMS_Thumbnail	360

////////////////////////////////////////////////////////////////////////////////////////////////////
// image type definition 

typedef NS_OPTIONS(NSInteger, WC_ImageType)
{
	WC_IT_None = 0,
	WC_IT_FrontSide = 0x01 << 0,
	WC_IT_BackSide  = 0x01 << 1,
	WC_IT_IDPhoto   = 0x01 << 2,
};

typedef NS_OPTIONS(NSInteger, WC_ImageSubType)
{
	WC_IST_None = 0,
	WC_IST_Original,
	WC_IST_Browse,
	WC_IST_Thumbnail,
    WC_IST_ReRecogn
};


#endif
