//
//  WCGroupModel+Tree.h
//

#import "WCGroupModel.h"

@interface WCGroupModel (Tree)

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods

/**
 在子類別中尋找group

 @param guid 要尋找的groupGuid
 @return 找到的groupModel
 */
- (WCGroupModel *)groupInTreeWithGuid:(NSString *)guid;

/**
 在子類別中尋找group
 
 @param groupID 要尋找的groupID
 @param sourceID 要尋找的sourceID
 @return 找到的groupModel
 */
- (WCGroupModel *)groupInTreeWithID:(NSInteger)groupID sourceID:(NSInteger)sourceID;

/**
 本身當作root，找出輸入group的所有父類別名稱

 @param groupID 要尋找的groupID
 @return 由root開始的所有父類別名稱
 */
- (NSMutableArray *)superGroupNamesInTreeWithID:(NSInteger)groupID;


/**
 本身當作root，找出輸入group的所有父類別名稱
 
 @param groupID 要尋找的groupID
 @return 由root開始的所有父類別名稱
 */
- (NSMutableArray *)superGroupNamesInTreeWithGuid:(NSString *)groupGuid;

/**
 本身當作root，找出輸入group的所有類別階層
 
 @param groupID 要尋找的groupID
 @return 由root開始到包含groupID的所有類別階層
 */
- (NSMutableArray *)layerGroupsInTreeWithID:(NSInteger)groupID;

/**
 將輸入群組的所有父類別設定為展開 （不包含輸入群組）

 @param groupGuid 要尋找的groupGuid
 */
- (void)expandSuperGroupInTreeWithGroupGuid:(NSString *)groupGuid;

/**
 找出tree中所有展開group的guid

 @return 所有展開的group guid
 */
- (NSMutableArray *)expandedGroupGuidsInTree;

/**
 設定tree中哪些group要展開

 @param guids 要展開的group guid
 */
- (void)setExpandedGroupInTreeWithGuids:(NSMutableArray *)guids;

/**
 設定tree中所有node的owner
 
 @param ownerGuid Owner guid
 */
- (void)setOwnerOfTreeWithGuid:(NSString *)ownerGuid;

/**
 取得子類別階層數量

 @return 階層數量
 */
- (NSInteger)subGroupLayerCount;


/**
 * 輸入groupIDArray，並在樹中找到完整的父類別字串
 * @param groupIDArray array of group ID string
 * @param isGroupMissing 用來回傳是否有類別無法找到完整父類別
 * @return 多層，多類別的顯示字串
 */

- (NSString *)displayGroupStringWithGroupIDArray:(NSArray *)groupIDArray isGroupMissing:(BOOL *)isGroupMissing;

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class methods

/**
 建立groupTree
 
 @param groups 要組成tree的所有group
 @return root group
 */
+ (WCGroupModel *)groupTreeWithGroups:(NSArray *)groups;

@end
