//
//  WCGroupDefine.h
//  WorldCard series
//
//  [macOS]注意：WC_GID_Unverified/WC_GID_Favorite 兩種分類方式雖然和一般group的操作不同，
//              但因管理介面上的需求，還是要定義對應的groupID。
//

#ifndef WorldCard_WCGroupDefine_h
#define WorldCard_WCGroupDefine_h

typedef NS_OPTIONS(NSInteger, WC_GroupID)
{
    WC_GID_AllCardInDb = -1,    // 6.x 使用，7.0 後不使用了
	WC_GID_None = 0,

    // WorldCard virtual groups
	WC_GID_All = 1,
	WC_GID_Unverified = 2,      // [iOS] 6.x 使用，7.0 後不使用了; [macOS] 4.0開始使用
    WC_GID_Favorite = 3,        // [macOS] 4.0開始使用
    WC_GID_Undownload = 4,      // [WorldCardTeam] 1.3開始使用
    
    // Google virtual groups
    WC_GID_Google_MyContacts = 11,
    WC_GID_Google_Friends = 12,
    WC_GID_Google_Family = 13,
    WC_GID_Google_Coworkers = 14,
    
//    WC_GID_Google_OtherContacts = 16, // use WC_GID_Unfiled instead

    WC_GID_Salesforce_Uploaded = 17,
    WC_GID_Salesforce_Unuploaded = 18,

    // 100以後保留給使用者自訂的group
    WC_GID_Unfiled = 100,
};


////////////////////////////////////////////////////////////////////////////////////////////////////
// Google Contacts Group Name (from PPWCXFDefine.h)

#define WC_GCGN_All @"All Contacts,所有聯絡人,所有联系人,全てのコンタクト,모든 주소록,Alle Kontakte,Tous les contacts,Tutti I contatti,Todos los contactos,Todos os contactos,Alle contacten"
#define WC_GCGN_OtherContacts @"Other Contacts,其他聯絡人,其他联系人,その他の連絡先,기타 주소록,Weitere Kontakte,Autres contacts,Altri contatti,Otros contactos,Outros contactos,Andere contactpersonen"
#define WC_GCGN_MyContacts @"My Contacts (Gmail),我的聯絡人 (Gmail),通讯录 (Gmail),Myコンタクト (Gmail),내 주소록 (Gmail),Meine Kontakte (Gmail),Mes contacts (Gmail),Contatti personali (Gmail),Mis contactos (Gmail),Contactos pessoais (Gmail),Mijn contactpersonen (Gmail)"
#define WC_GCGN_Friends @"Friends (Gmail),好友 (Gmail),朋友 (Gmail),友達 (Gmail),친구 (Gmail),Freunde (Gmail),Amis (Gmail),Amici (Gmail),Amigos (Gmail),Amigos (Gmail),Vrienden (Gmail)"
#define WC_GCGN_Family @"Family (Gmail),家人 (Gmail),家人 (Gmail),家族 (Gmail),가족 (Gmail),Familie (Gmail),Famille (Gmail),Famiglia (Gmail),Familia (Gmail),Família (Gmail),Familie (Gmail)"
#define WC_GCGN_Coworkers @"Coworkers (Gmail),同事 (Gmail),同事 (Gmail),同僚 (Gmail),동료 (Gmail),Kollegen (Gmail),Collègues (Gmail),Colleghi (Gmail),Compañeros (Gmail),Colegas de trabalho (Gmail),Collega's (Gmail)"
#define WC_GCGN_StarredInAndroid @"Starred in Android"  // 這個是可以刪除的

#endif
