//
//  WCFieldDefine.h
//  WorldCard series
//
//  Created by  Eddie on 2012/3/22.
//  Copyright 2011 Penpower. All rights reserved.
//

#ifndef WorldCard_WCFieldDefine_h
#define WorldCard_WCFieldDefine_h

#define WC_InvalidRecordID  -1

////////////////////////////////////////////////////////////////////////////////////////////////////
/// value type definition

typedef NS_OPTIONS(NSInteger, WC_ValueType)
{
    WC_VT_None = 0,
    WC_VT_String,
    WC_VT_Integer,
    WC_VT_DateTime,
    WC_VT_Dictionary,
    WC_VT_UserDefined,
};



////////////////////////////////////////////////////////////////////////////////////////////////////
/// field source definition

typedef NS_OPTIONS(NSInteger, WC_FieldSource)
{
    WC_FS_UserCreate = 0,	// 手動建立
    WC_FS_FrontRecog,		// 正面辨識
    WC_FS_BackRecog			// 反面辨識
};



////////////////////////////////////////////////////////////////////////////////////////////////////
/// Name order definition
// deprecated, 使用WCDisplayNameOrder

typedef __attribute__((deprecated)) NS_OPTIONS(NSInteger, WC_NameOrder)
{
    WC_NO_None = 0,
    WC_NO_FirstLast,
    WC_NO_LastFirst,
};

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Sorted by field definition

typedef NS_OPTIONS(NSInteger, WC_SortedByField)
{
    WC_SBF_None = 0,
    WC_SBF_Name,
    WC_SBF_Company,
    WC_SBF_CreateTime,
    WC_SBF_ModifiedTime,
};

////////////////////////////////////////////////////////////////////////////////////////////////////
/// contact action definition

typedef NS_OPTIONS(NSInteger, ContactActionType)
{
    ContactActionType_Tel=0,
    ContactActionType_SMS,
    ContactActionType_EMail,
    ContactActionType_Map,
    ContactActionType_Skype,
    ContactActionType_FaceTime,
    ContactActionType_Hangouts,
};

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Address format value definition (same as WCXF)
/*
 (Format ID)
 1.	中國 香港 Country+Province+City,+Street+", "+Postalcode
 2.	英文 Street+", "+City+", "+Province+" "+Postalcode+" "+Country
 3.	歐文 Street+", "+Postalcode+" "+City+" "+Province+" "+Country
 4.	日本 〒Postalcode+" "+Country+Province+City+Street
 5.	台灣 韓國 Postalcode+" "+Country+Province+City+Street
 6.	新加坡 Street+" "+Country+" "+Postalcode
 7.	印度 Street+", "+City+", "+Postalcode+" "+Province+", "+Country
 8.	加拿大 Street+", "+City+", "+Province+", "+Country+" "+Postalcode
 9.	俄羅斯 Country+" "+Postalcode+" "+Province+", "+City+", "+Street
 10.匈牙利 Postalcode+" "+City+", "+Province+", "+Street+", "+Country
 */

typedef NS_OPTIONS(NSInteger, WC_AddressFormat)
{
    WC_AF_None = 0,
    WC_AF_China,	// country + state + city + street + " ," + zip
    WC_AF_USA,		// street + "," + city + ", " + state + " " + zip + " " + country
    WC_AF_Europe,	// street + ", " + zip + " " + city + " " + state + " " + country
    WC_AF_Japan,	// "〒" + ZIP + " " + country + state + city + street
    WC_AF_Taiwan,		// ZIP + " " + country + state + city + street
    WC_AF_Singapore,
    WC_AF_India,
    WC_AF_Canada,
    WC_AF_Russia,
    WC_AF_Hungarian,
};

////////////////////////////////////////////////////////////////////////////////////////////////////
// salesforce saveAs Define
typedef NS_ENUM(NSInteger, WC_SF_SaveAs)
{
    WC_SF_SaveAs_None = 0,
    WC_SF_SaveAs_Contacts,
    WC_SF_SaveAs_Leads,
};

static NSString *WC_SF_SaveAsString_Leads = @"Leads";
static NSString *WC_SF_SaveAsString_Contacts = @"Contacts";

////////////////////////////////////////////////////////////////////////////////////////////////////
static NSString *WC_SF_FieldName_Rating = @"rating";
static NSString *WC_SF_FieldName_Industry = @"industry";
static NSString *WC_SF_FieldName_Salutation = @"salutation";
static NSString *WC_SF_FieldName_Status = @"status";
static NSString *WC_SF_FieldName_LeadSource = @"leadsource";
////////////////////////////////////////////////////////////////////////////////////////////////////
// field type definition

// field max count
#define WC_FMC_Name                 4
#define WC_FMC_Company              6
#define WC_FMC_Address              6
#define WC_FMC_Phone                16
#define WC_FMC_Email                6
#define WC_FMC_URL                  6
#define WC_FMC_InstantMessage       10
#define WC_FMC_SocialNetWork        10
#define WC_FMC_Date                 4
#define WC_FMC_Note                 1
#define WC_FMC_Nickname             1
#define WC_FMC_UnifiedBusinessNo    1
#define WC_FMC_BirthDay             1
#define WC_FMC_UserDefine           16

/// main type
typedef NS_OPTIONS(NSInteger, WC_FieldType)
{
    WC_FT_None = 0,
    WC_FT_Name = 1,     // 1 : has value combined type
    WC_FT_Company = 2,  // 2 : has value combined type
    WC_FT_Address = 3,  // 3 : has value combined type
    WC_FT_Phone = 4,
    WC_FT_Email = 5,
    WC_FT_URL = 6,
    WC_FT_InstantMessage = 7,
    WC_FT_Date = 8,
    WC_FT_Note = 9,
    WC_FT_Nickname = 10,
    WC_FT_UnifiedBusinessNo = 11,  //統一編號，中文版才有用
    WC_FT_SocialNetwork = 12,  //社群網路，WCT 1.0.0 新增
    WC_FT_UserDefine = 13, //使用者自訂欄位, WCE 新增
    WC_FT_SalesforceData = 14, // salesforce專屬的欄位資料，WCSF 1.0新增
    WC_FT_Office365Data = 15, // office365 專屬的欄位資料
};



////////////////////////////////////////////////////////////////////////////////////////////////////
/// field sub type 1

typedef NS_OPTIONS(NSInteger, WC_FieldSubType1)
{
    WC_FST1_None = 0,
    
    WC_FST1_Address_Work = WC_FT_Address*100,
    WC_FST1_Address_Home,
    WC_FST1_Address_Other,
    
    WC_FST1_Phone_Work = WC_FT_Phone*100,
    WC_FST1_Phone_Home,
    WC_FST1_Phone_Mobile,
    WC_FST1_Phone_Main,
    WC_FST1_Phone_WorkFax,
    WC_FST1_Phone_HomeFax,
    WC_FST1_Phone_Pager,
    WC_FST1_Phone_GoogleVoice,
    WC_FST1_Phone_iPhone,
    WC_FST1_Phone_Other,
    WC_FST1_Phone_OtherFax,  // add since WCE 
    
    WC_FST1_Email_Work = WC_FT_Email*100,
    WC_FST1_Email_Home,
    WC_FST1_Email_Other,
    
    WC_FST1_URL_HomePage = WC_FT_URL*100,
    WC_FST1_URL_Work,
    WC_FST1_URL_Home,
    WC_FST1_URL_Profile,
    WC_FST1_URL_Blog,
    WC_FST1_URL_Other,
    
    WC_FST1_IM_MSN = WC_FT_InstantMessage*100,
    WC_FST1_IM_Skype,
    WC_FST1_IM_QQ,
    WC_FST1_IM_Yahoo,
    WC_FST1_IM_ICQ,
    WC_FST1_IM_GoogleTalk,
    WC_FST1_IM_Jabber,
    WC_FST1_IM_AIM,
    WC_FST1_IM_Other,
    WC_FST1_IM_GaduGadu, // add since WCT 1.0.0

    WC_FST1_Date_Birthday = WC_FT_Date*100,
    WC_FST1_Date_Anniversary,
    WC_FST1_Date_Other,
    
    WC_FST1_SN_Twitter = WC_FT_SocialNetwork*100,
    WC_FST1_SN_Facebook,
    WC_FST1_SN_Flicker,
    WC_FST1_SN_LinkedIn,
    WC_FST1_SN_MySpace,
    WC_FST1_SN_SinaWebo,
    WC_FST1_SN_Other,
    
    WC_FST1_SFData_LeadSource = WC_FT_SalesforceData*100, ///< add sinceWCSF 1.0
    WC_FST1_SFData_Status,
    WC_FST1_SFData_Industry,
    WC_FST1_SFData_Rating,
    WC_FST1_SFData_ContactID,
    WC_FST1_SFData_SaveAs, ///< value, WC_SF_SaveAs
    
    WC_FST1_Office365Data_ContactID = WC_FT_Office365Data*100
};



////////////////////////////////////////////////////////////////////////////////////////////////////
/// field sub type 2

typedef NS_OPTIONS(NSInteger, WC_FieldSubType2)
{
    WC_FST2_None = 0,
    WC_FST2_SearchOnly,
    
    WC_FST2_Name_First = WC_FT_Name*100+50,
    WC_FST2_Name_FirstPhonetic,
    WC_FST2_Name_Last,
    WC_FST2_Name_LastPhonetic,
    WC_FST2_Name_Middle,
    WC_FST2_Name_Prefix,
    WC_FST2_Name_Suffix,
    WC_FST2_Name_FirstLast_SearchOnly, // WCE 新增，用來姓名欄位搜尋，不管顯示規則
    WC_FST2_Name_LastFirst_SearchOnly, // WCE 新增，用來姓名欄位搜尋，不管顯示規則
    
    WC_FST2_Company_Name = WC_FT_Company*100+50,
    WC_FST2_Company_Phonetic,
    WC_FST2_Company_Department,
    WC_FST2_Company_JobTitle,
    
    WC_FST2_Address_Street = WC_FT_Address*100+50,
    WC_FST2_Address_City,
    WC_FST2_Address_State,
    WC_FST2_Address_ZIP,
    WC_FST2_Address_Country,
    WC_FST2_Address_CountryCode,
    WC_FST2_Address_Format,
    WC_FST2_Address_Location,
    WC_FST2_Address_LanguageCode,       // WCT新增
};




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Year Define

static NSUInteger const WC_ValidMinYear = 1900;






////////////////////////////////////////////////////////////////////////////////////////////////////
/// Type string for debug
static NSDictionary *WC_FieldStringDict = nil;

NS_INLINE NSString *WCFieldTypeString(NSInteger type)
{
    WC_FieldStringDict = @{
        @(WC_FT_None):@"WC_FT_None",
        @(WC_FT_Name):@"WC_FT_Name",
        @(WC_FT_Company):@"WC_FT_Company",
        @(WC_FT_Address):@"WC_FT_Address",
        @(WC_FT_Phone):@"WC_FT_Phone",
        @(WC_FT_Email):@"WC_FT_Email",
        @(WC_FT_URL):@"WC_FT_URL",
        @(WC_FT_InstantMessage):@"WC_FT_InstantMessage",
        @(WC_FT_SocialNetwork):@"WC_FT_SocialNetwork",
        @(WC_FT_Date):@"WC_FT_Date",
        @(WC_FT_Note):@"WC_FT_Note",
        @(WC_FT_Nickname):@"WC_FT_Nickname",
        @(WC_FT_UnifiedBusinessNo):@"WC_FT_UnifiedBusinessNo",
        @(WC_FT_UserDefine):@"WC_FT_UserDefine",
        @(WC_FT_SalesforceData):@"WC_FT_SalesforceData",
                
        @(WC_FST1_None):@"WC_FST1_None",
        @(WC_FST1_Address_Work):@"WC_FST1_Address_Work",
        @(WC_FST1_Address_Home):@"WC_FST1_Address_Home",
        @(WC_FST1_Address_Other):@"WC_FST1_Address_Other",
                
        @(WC_FST1_Phone_Work):@"WC_FST1_Phone_Work",
        @(WC_FST1_Phone_Home):@"WC_FST1_Phone_Home",
        @(WC_FST1_Phone_Mobile):@"WC_FST1_Phone_Mobile",
        @(WC_FST1_Phone_Main):@"WC_FST1_Phone_Main",
        @(WC_FST1_Phone_WorkFax):@"WC_FST1_Phone_WorkFax",
        @(WC_FST1_Phone_HomeFax):@"WC_FST1_Phone_HomeFax",
        @(WC_FST1_Phone_Pager):@"WC_FST1_Phone_Pager",
        @(WC_FST1_Phone_GoogleVoice):@"WC_FST1_Phone_GoogleVoice",
        @(WC_FST1_Phone_iPhone):@"WC_FST1_Phone_iPhone",
        @(WC_FST1_Phone_Other):@"WC_FST1_Phone_Other",
                
        @(WC_FST1_Email_Work):@"WC_FST1_Email_Work",
        @(WC_FST1_Email_Home):@"WC_FST1_Email_Home",
        @(WC_FST1_Email_Other):@"WC_FST1_Email_Other",
                
        @(WC_FST1_URL_HomePage):@"WC_FST1_URL_HomePage",
        @(WC_FST1_URL_Work):@"WC_FST1_URL_Work",
        @(WC_FST1_URL_Home):@"WC_FST1_URL_Home",
        @(WC_FST1_URL_Profile):@"WC_FST1_URL_Profile",
        @(WC_FST1_URL_Blog):@"WC_FST1_URL_Blog",
        @(WC_FST1_URL_Other):@"WC_FST1_URL_Other",
                
        @(WC_FST1_IM_MSN):@"WC_FST1_IM_MSN",
        @(WC_FST1_IM_Skype):@"WC_FST1_IM_Skype",
        @(WC_FST1_IM_QQ):@"WC_FST1_IM_QQ",
        @(WC_FST1_IM_Yahoo):@"WC_FST1_IM_Yahoo",
        @(WC_FST1_IM_ICQ):@"WC_FST1_IM_ICQ",
        @(WC_FST1_IM_GoogleTalk):@"WC_FST1_IM_GoogleTalk",
        @(WC_FST1_IM_Jabber):@"WC_FST1_IM_Jabber",
        @(WC_FST1_IM_AIM):@"WC_FST1_IM_AIM",
        @(WC_FST1_IM_GaduGadu):@"WC_FST1_IM_GaduGadu",
        @(WC_FST1_IM_Other):@"WC_FST1_IM_Other",
                
        @(WC_FST1_SN_Twitter):@"WC_FST1_SN_Twitter",
        @(WC_FST1_SN_Facebook):@"WC_FST1_SN_Facebook",
        @(WC_FST1_SN_Flicker):@"WC_FST1_SN_Flicker",
        @(WC_FST1_SN_LinkedIn):@"WC_FST1_SN_LinkedIn",
        @(WC_FST1_SN_MySpace):@"WC_FST1_SN_MySpace",
        @(WC_FST1_SN_SinaWebo):@"WC_FST1_SN_SinaWebo",
        @(WC_FST1_SN_Other):@"WC_FST1_SN_Other",
                
                // add sinceWCSF 1.0
        @(WC_FST1_SFData_LeadSource):@"WC_FST1_SFData_LeadSource",
        @(WC_FST1_SFData_Status):@"WC_FST1_SFData_Status",
        @(WC_FST1_SFData_Industry):@"WC_FST1_SFData_Industry",
        @(WC_FST1_SFData_Rating):@"WC_FST1_SFData_Rating",
        @(WC_FST1_SFData_SaveAs):@"WC_FST1_SFData_SaveAs",
        @(WC_FST1_SFData_ContactID):@"WC_FST1_SFData_ContactID",
                
                
        @(WC_FST1_Date_Birthday):@"WC_FST1_Date_Birthday",
        @(WC_FST1_Date_Anniversary):@"WC_FST1_Date_Anniversary",
        @(WC_FST1_Date_Other):@"WC_FST1_Date_Other",
                
        @(WC_FST2_None):@"WC_FST2_None",
        @(WC_FST2_SearchOnly):@"WC_FST2_SearchOnly",
                
        @(WC_FST2_Name_First):@"WC_FST2_Name_First",
        @(WC_FST2_Name_FirstPhonetic):@"WC_FST2_Name_FirstPhonetic",
        @(WC_FST2_Name_Last):@"WC_FST2_Name_Last",
        @(WC_FST2_Name_LastPhonetic):@"WC_FST2_Name_LastPhonetic",
        @(WC_FST2_Name_Middle):@"WC_FST2_Name_Middle",
        @(WC_FST2_Name_Prefix):@"WC_FST2_Name_Prefix",
        @(WC_FST2_Name_Suffix):@"WC_FST2_Name_Suffix",
                
        @(WC_FST2_Company_Name):@"WC_FST2_Company_Name",
        @(WC_FST2_Company_Phonetic):@"WC_FST2_Company_Phonetic",
        @(WC_FST2_Company_Department):@"WC_FST2_Company_Department",
        @(WC_FST2_Company_JobTitle):@"WC_FST2_Company_JobTitle",
                
        @(WC_FST2_Address_Street):@"WC_FST2_Address_Street",
        @(WC_FST2_Address_City):@"WC_FST2_Address_City",
        @(WC_FST2_Address_State):@"WC_FST2_Address_State",
        @(WC_FST2_Address_ZIP):@"WC_FST2_Address_ZIP",
        @(WC_FST2_Address_Country):@"WC_FST2_Address_Country",
        @(WC_FST2_Address_CountryCode):@"WC_FST2_Address_CountryCode",
        @(WC_FST2_Address_Format):@"WC_FST2_Address_Format",
        @(WC_FST2_Address_Location):@"WC_FST2_Address_Location",
        @(WC_FST2_Address_LanguageCode):@"WC_FST2_Address_LanguageCode",
    };
    
    return [WC_FieldStringDict objectForKey:@(type)];
};

#endif
