//
//  WCCoverFlowControllerDataSource.h
//  Pods
//
//  Created by sanhue on 2016/6/20.
//
//

#ifndef WCCoverFlowControllerDataSource_h
#define WCCoverFlowControllerDataSource_h

#import "WCCardModel.h"
#import "WCImageDefine.h"


@class WCCoverFlowController;

@protocol WCCoverFlowControllerDataSource <NSObject>

/**
 * 取得所有名片資料
 * @param coverFlowController instance of flow controller
 * @return NSArray array of PPSectionModel, and cardArray of PPSectionModel contains PPRowModel, and object of PPRowModel contains WCCardModel
 */
- (NSArray *)cardSectionArrayWithCoverFlowController:(WCCoverFlowController *)coverFlowController;


/**
 * 取得指定名片的完整資料
 * @param coverFlowController instance of flow controller
 * @param cardID 指定的cardID
 * @return WCCardModel 取得的名片資料
 */
- (WCCardModel *)coverFlowController:(WCCoverFlowController *)coverFlowController requestFullCardModelWithCardID:(NSString *)cardID;


/**
 * 取得名片圖
 * @param coverFlowController instance of flow controller
 * @param cardID 要取得的
 * @return UIImage 名片圖
 */
- (UIImage *)coverFlowController:(WCCoverFlowController *)coverFlowController cardImageWithCardID:(NSString *)cardID imageType:(WC_ImageType)imageType imageSubType:(WC_ImageSubType)imageSubType;

@optional


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - optional

#pragma mark - data checking


/**
 * 檢查cardID是否存在
 * @param coverFlowController instance of flow controller
 * @param cardID 要檢查的聯絡人ID
 * @return BOOL YES:存在，NO:不存在, default NO
 */
- (BOOL)coverFlowController:(WCCoverFlowController *)coverFlowController isCardIDExist:(NSString *)cardID;


/**
 * 是否為我的最愛名片
 * @param coverFlowController instance of flow controller
 * @param cardID 要檢查的聯絡人ID
 * @return BOOL YES:是我的最愛，NO:不是, default NO
 */
- (BOOL)coverFlowController:(WCCoverFlowController *)coverFlowController isFavoriteWithCardID:(NSString *)cardID;

@end

#endif /* WCCoverFlowControllerDataSource_h */
