//
//  WCCoverFlowController.h
//  Pods
//
//  Created by sanhue on 2016/6/20.
//
//
/**
 * 目的:簡化使用WCCoverFlowViewController的方式
 * 原則:
 * 1. WCCoverFlowController建立時WCCoverFlowViewController就要先建立
 * 2. 一進mainViewController就是橫式，直接進coverflow
 * 3. 旋轉為橫式時加入mainViewController, 轉為直式移除
 * 4. WCCoverFlowViewController的viewWillAppear, viewDidAppear, viewWillDisAppear, viewDidDisAppear不準確，所以不要在裡面做事，
 viewWillAppear, viewDidAppear要做的事放到addCoverFlowViewController, viewWillDisAppear, viewDidDisAppear放到removeCoverFlowViewController
 */

#import <Foundation/Foundation.h>
#import "WCCoverFlowControllerDelegate.h"
#import "WCCoverFlowControllerDataSource.h"
#import "WCCoverFlowViewController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCCoverFlowController : NSObject


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - property

/// coverFlowViewController的實體
@property (nonatomic, retain, readonly) WCCoverFlowViewController *coverFlowViewController;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init

/// 傳入delegate並初始化
- (instancetype)initWithDelegate:(id)delegate;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - display control methods

/**
 * 顯示Cover flow
 * @param mode 顯示模式，分cardholder與favorite
 * @param viewController 從哪一個view controller顯示
 */
- (void)addCoverFlowViewControllerWithMode:(WCCoverFlowViewControllerMode)mode
                           onViewController:(UIViewController *)viewController;

/// 移除cover flow view controller
- (void)removeCoverFlowController;





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - attribute 


/**
 * 設定沒有名片圖，與無姓名的顯示字串
 * @param noContact 沒有名片時的顯示字串，nil表示不顯示，預設nil
 * @param noName 沒有姓名時的顯示字串，nil表示不顯示，預設nil
 */
- (void)setStringForNoContact:(NSString *)noContact noName:(NSString *)noName;

/// 目前cover flow的顯示模式
- (WCCoverFlowViewControllerMode)mode;

/// 設定類別名稱
- (void)setCategoryName:(NSString *)categoryName;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - utility methods

/// 強制重新讀取內容
- (void)reloadData;
@end
