//
//  WCContactFootView.h
//  Pods
//
//  Created by Andrew on 2015/7/8.
//
//

#import <UIKit/UIKit.h>
#import "PPTableView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@class WCContactFootView;

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol WCContactFootViewDataSource <NSObject>

@required

/**
 * Asks the data source to return the number of sections in the contactFootTableView
 * @param contactFootView An object representing the table view requesting this information.
 * @return The number of sections in contactFootTableView
 */
- (NSInteger)numberOfSectionsInWCContactFootView:(WCContactFootView *)contactFootView;


/**
 * Tells the data source to return the number of rows in a given section of a table view
 * @param contactFootView The table-view object requesting this information
 * @param section An index number identifying a section in tableView
 * @return: The number of rows in section
 */
- (NSInteger)contactFootView:(WCContactFootView *)contactFootView numberOfRowsInSection:(NSInteger)section;


/**
 * Asks the data source for a cell to insert in a particular location of the table view
 * @param contactFootView A WCContactFootView object requesting the cell
 * @param indexPath An index path locating a row in tableView
 * @return: An object inheriting from UITableViewCell that the table view can use for the specified row
 */
- (UITableViewCell *)contactFootView:(WCContactFootView *)contactFootView cellForRowAtIndexPath:(NSIndexPath *)indexPath;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol WCContactFootViewDelegate <NSObject>

@required
- (CGFloat)contactFootView:(WCContactFootView *)contactFootView estimatedHeightForRowAtIndexPath:(NSIndexPath *)indexPath;
- (CGFloat)contactFootView:(WCContactFootView *)contactFootView heightForRowAtIndexPath:(NSIndexPath *)indexPath;
- (void)contactFootView:(WCContactFootView *)contactFootView didSelectIndexPath:(NSIndexPath *)indexPath;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCContactFootView : UIView <UITableViewDataSource, UITableViewDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic, assign)   id<WCContactFootViewDataSource> dataSource;
@property (nonatomic, assign)   id<WCContactFootViewDelegate>   delegate;
@property (nonatomic, readonly) PPTableView                     *contactFootTableView;

@end
