//
//  WCContactEditViewControllerDelegate.h
//
//
//  Created by Howard on 2015/9/17.
//
//

#import <Foundation/Foundation.h>
#import "WCContactEditViewController+PublicParameterDefine.h"


@class WCContactEditViewController;

@protocol WCContactEditViewControllerDelegate <NSObject>

@required
/**
 *  編輯元件動作
 *
 *  @param contactEditViewController 委托者
 *  @param action                    動作
 */
- (void)contactEditViewController:(WCContactEditViewController *)contactEditViewController action:(WCContactEditViewControllerAction)action;



/**
 *  判斷連絡人ID 是否存在
 *
 *  @param cardID 連絡人ID
 *
 *  @return YES, 存在
 */
- (BOOL)cardIDExistInWCContactViewEditViewController:(NSString *)cardID;


@optional

/**
 *  編輯元件，大頭照是否能編輯
 *
 *  @param contactEditViewController 委托者
 *
 *  @return YES 編輯， NO，不能編輯
 */
- (BOOL)contactEditViewControllerCouldEditHeadImage:(WCContactEditViewController *)contactEditViewController;

/**
 *  編輯元件，編輯結束是否送出資料，
 *
 *  @param contactEditViewController 委托者
 *
 *  @return YES 送出， NO 不送
 */
- (BOOL)contactEditViewControllerWillSendDataWithEditFinished:(WCContactEditViewController *)contactEditViewController;

@end


