//
//  WCContactEditFieldViewController.h
//
//  Created by Howard.Lin on 13/10/1.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPViewController.h"
#import "WCContactEditFieldSectionController.h"
#import "ContactEditFieldView.h"
#import "ContactEditFieldNavigationBarView.h"
#import "PPContactAddressFormatDefine.h"
#import "PPContactNameOrderDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCContactEditFieldViewControllerMode)
{
    WCContactEditFieldViewControllerMode_AddField,
    WCContactEditFieldViewControllerMode_ChangeTitle,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCContactEditFieldViewControllerDelegate Method

@class WCContactEditFieldViewController;

@protocol WCContactEditFieldViewControllerDelegate <NSObject>

@required

/**
 * To notify delegate, the contactEditFieldViewController.contactEditFieldView.editFieldTableView.cell title is selected.
 * @param title The title is selected
 * contactMainType The contactMainType which you selected.
 */
 - (void)contactEditFieldViewController:(WCContactEditFieldViewController *)contactEditFieldViewController
                         didSelectTitle:(NSString *)title
                  forPPContactMainType:(PPContactMainType)contactMainType;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCContactEditFieldViewController : PPViewController <ContactEditFieldViewDataSource,ContactEditFieldViewDelegate,ContactEditFieldNavigationBarViewDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign)   id<WCContactEditFieldViewControllerDelegate> delegate;
@property (nonatomic,readonly) WCContactEditFieldSectionController          *contactEditFieldSectionController;
@property (nonatomic,assign)   WCContactEditFieldViewControllerMode         contactEditFieldViewControllerMode;
@property (nonatomic,assign)   BOOL                                         showDoneButton;
@property (nonatomic,copy)     NSString                                     *currentSelectedTitle;


@end
