//
//  PPDateSectionController.h
//
//
//  Created by Howard on 2017/2/9.
//
//

#import "PPSectionController.h"

// Define
#import "PPDateSectionController+ParameterDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPDateSectionController : PPSectionController





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (void)generateDataForComponents:(NSArray <NSNumber *> *)components;



/**
 合法的日期

 @param yearIndexPath year indexPath
 @param monthIndexPath month indexPath
 @param dayIndexPath day indexPath
 @param error 回傳錯誤
 @return YES, 合法
 */
- (BOOL)validDayWithYearIndexPath:(NSIndexPath *)yearIndexPath
                   monthIndexPath:(NSIndexPath *)monthIndexPath
                     dayIndexPath:(NSIndexPath *)dayIndexPath
                            error:(NSError **)error;



/**
 最近合法日期 indexPath

 @param yearIndexPath year indexPath
 @param monthIndexPath month indexPath
 @param dayIndexPath day indexPath
 @return 最近合法日期 indexPath
 */
- (NSIndexPath *)approachValidDayIndexPathWithYearIndexPath:(NSIndexPath *)yearIndexPath
                                             monthIndexPath:(NSIndexPath *)monthIndexPath
                                               dayIndexPath:(NSIndexPath *)dayIndexPath;


/**
 取得對應title的row

 @param text 標題
 @param section section
 @return row index
 */
- (NSInteger)rowForRowModelText:(NSString *)text atSection:(NSUInteger)section;
@end
