//
//  PPContactSubTypeDefine.h
//
//  Created by Howard.Lin on 13/10/9.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#ifndef CloudEditViewControllerDemo_PPContactSubTypeDefine_h
#define CloudEditViewControllerDemo_PPContactSubTypeDefine_h

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPContactSubTypeDistance  100

typedef NS_ENUM(NSUInteger,PPContactSubType)
{
    PPContactSubType_None,

    //name
    PPContactSubType_Name_FirstName,
    PPContactSubType_Name_FirstNamePhonetic,
    PPContactSubType_Name_MiddleName,
    PPContactSubType_Name_LastName,
    PPContactSubType_Name_LastNamePhonetic,
    PPContactSubType_Name_Prefix,
    PPContactSubType_Name_Surffix,
    
    //company
    PPContactSubType_Company_Name = PPContactSubTypeDistance * 1,
    PPContactSubType_Company_NamePhonetic,
    PPContactSubType_Company_Department,
    PPContactSubType_Company_JobTitle,
    
    //address
    PPContactSubType_Address_Street = PPContactSubTypeDistance * 2,
    PPContactSubType_Address_City,
    PPContactSubType_Address_State,
    PPContactSubType_Address_Zip,
    PPContactSubType_Address_Country,
    PPContactSubType_Address_CountryCode,
    PPContactSubType_Address_Format,
    PPContactSubType_Address_GPS,
    PPContactSubType_Address_RecognitionLanguageCode,
    
    //frontCardImage
    PPContactSubType_FrontCardImage_Default = PPContactSubTypeDistance * 3,
    PPContactSubType_FrontCardImage_Thumbnail,
    PPContactSubType_FrontCardImage_Medium,
    PPContactSubType_FrontCardImage_Original,

    //backCardImage
    PPContactSubType_BackCardImage_Thumbnail = PPContactSubTypeDistance * 4,
    PPContactSubType_BackCardImage_Medium,
    PPContactSubType_BackCardImage_Original,

    //headImage
    PPContactSubType_HeadImage_Thumbnail = PPContactSubTypeDistance * 5,
    PPContactSubType_HeadImage_Medium,
    PPContactSubType_HeadImage_Original,
    
    //userDefine
    PPContactSubType_UserDefine_Integer = PPContactSubTypeDistance * 6,
    PPContactSubType_UserDefine_Float,
    PPContactSubType_UserDefine_Text,
    PPContactSubType_UserDefine_ListValue,
    PPContactSubType_UserDefine_Email,
    PPContactSubType_UserDefine_URL,
    PPContactSubType_UserDefine_ItemMenu,
    PPContactSubType_UserDefine_Date,
    PPContactSubType_UserDefine_DateAndTime,
    PPContactSubType_UserDefine_ID,
    PPContactSubType_UserDefine_UserInfo,

    //Group
    PPContactSubType_Group = PPContactSubTypeDistance * 7,
    PPContactSubType_GroupID,
    
    //System Group
    PPContactSubType_SaveToSystemGroup = PPContactSubTypeDistance * 8,
    PPContactSubType_SystemGroup,
    PPContactSubType_SystemGroupID,
    PPContactSubType_SystemGroupSourceID,
    
    // Visible Account
    PPContactSubType_VisibleAccount = PPContactSubTypeDistance * 9,
    PPContactSubType_VisibleAccountID,
    
    PPContactSubType_ListValue = PPContactSubTypeDistance * 10,
    PPContactSubType_ItemMenu,
};


#endif
