//
//  NoteViewController.h
//  Pods
//
//  Created by Howard on 2015/7/18.
//
//

#import "PPViewController.h"
#import "PPButton.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@class NoteViewController;

#pragma mark - Button Tag Define

typedef NS_ENUM(NSUInteger, NoteViewControllerButtonTag)
{
    NoteViewControllerButtonTag_Back,
    NoteViewControllerButtonTag_Done,
    NoteViewControllerButtonTag_InsertDate,
};

typedef void(^NoteCompleteHandler)(NoteViewController *noteViewController, PPButton *ppButton, UIControlEvents controllEvent);
////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - NoteViewControllerDelegate

@protocol  NoteViewControllerDelegate<NSObject>

- (void)noteViewController:(NoteViewController *)noteViewController ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - NoteViewController

@interface NoteViewController : PPViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property
/// 如果delegate, noteCompleteHandler都有設定，以noteCompleteHandler優先，delegate就不會呼叫
@property (nonatomic,assign) id<NoteViewControllerDelegate> noteViewControllerDelegate;
@property (nonatomic,copy)   NoteCompleteHandler            noteCompleteHandler;
@property (nonatomic,copy)   NSString                       *noteTextString;
@property (nonatomic,copy)   NSString                       *titleText;
@property (nonatomic,assign) BOOL                           noteEditting;
@property (nonatomic,assign) NSUInteger                     maxLength;      // default NSUIntegerMax

@end
