//
//  ContactTranslateNavigationBarView.h
//
//  Created by Howard.Lin on 13/12/24.
//  Modified by Andrew.Lai on 15/05/25.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPNavigationBarView.h"
#import "PPButton.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, ContactTranslateNavigationBarViewButtonTag)
{
    ContactTranslateNavigationBarViewButtonTag_Back = 1,
    ContactTranslateNavigationBarViewButtonTag_SourceLanguage,
    ContactTranslateNavigationBarViewButtonTag_Assign,
    ContactTranslateNavigationBarViewButtonTag_DestinationLanguage
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@class ContactTranslateNavigationBarView;
@protocol ContactTranslateNavigationBarViewDelegate <NSObject>

@required
 - (void)contactTranslateNavigationBarView:(ContactTranslateNavigationBarView *)contactTranslateNavigationBarView
                                  ppButton:(PPButton *)button
                          withControlEvent:(UIControlEvents)event;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ContactTranslateNavigationBarView : PPNavigationBarView <PPButtonDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic, assign) id<ContactTranslateNavigationBarViewDelegate>  delegate;
@property (nonatomic, retain) NSString                                      *sourceLanguageString;
@property (nonatomic, retain) NSString                                      *destinationLanguageString;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 * 顯示/隱藏翻譯工具列(來源語系按鈕＆目的地語系按鈕＆箭頭按鈕)
 */
- (void)showTranslateToolBar:(BOOL)isShow;

@end
