//
//  ContactEditViewDelegate.h
//  
//
//  Created by Howard on 2016/11/22.
//
//

#import <Foundation/Foundation.h>

@class ContactEditView;
@class ContactKeyboardToolBarView;
@class PPPhoneTextFieldTableViewCell;
@class PPTextFieldTableViewCell;
@class PPTextViewTableViewCell;
@class PPMultipleTextFieldButtonTableViewCell;
@class PPHeadImageNameTabelViewCell;
@class PPButton;

@protocol ContactEditViewDelegate <NSObject>

@required

/**
 * Tells the delegate that the specified row is now selected
 * @param contactEditView A contactEditView object informing the delegate about the new row selection
 * @param indexPath An index path locating the new selected row in contactEditTableView
 */
- (void)contactEditView:(ContactEditView *)contactEditView didSelectRowAtIndexPath:(NSIndexPath *)indexPath;


- (void)contactEditView:(ContactEditView *)contactEditView didDeselectRowAtIndexPath:(NSIndexPath *)indexPath;

/**
 * Tells the delegate that text of textfield has changed
 * @param contactEditView A contactEditView object informing the delegate about the editing
 * @param multipleTextFieldButtonTableViewCell The textfield of multipleTextFieldButtonTableViewCell for which an editing session began
 * @param tag The tag of textfield
 * @param indexPath An index path locating the new selected row in contactEditTableView
 */
- (void)contactEditView:(ContactEditView *)contactEditView ppMultipleTextFieldButtonTableViewCellDidChanged:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldButtonTableViewCell textFieldTag:(NSUInteger)tag atIndexPath:(NSIndexPath *)indexPath;


/**
 * Tells the delegate that text of textfield has changed
 * @param contactEditView A contactEditView object informing the delegate about the editing
 * @param phoneTextFieldTableViewCell The textfield of phoneTextFieldTableViewCell for which an editing session began
 * @param indexPath An index path locating the new selected row in contactEditTableView
 */
- (void)contactEditView:(ContactEditView *)contactEditView ppPhoneTextFieldTableViewCellDidChanged:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath;


/**
 * Tells the delegate that text of textfield has changed
 * @param contactEditView A contactEditView object informing the delegate about the editing
 * @param textFieldTableViewCell The textfield of textFieldTableViewCell for which an editing session began
 * @param indexPath An index path locating the new selected row in contactEditTableView
 */
- (void)contactEditView:(ContactEditView *)contactEditView ppTextFieldTableViewCellDidChanged:(PPTextFieldTableViewCell *)textFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath;


/**
 * Tells the delegate that text of textview has changed
 * @param contactEditView A contactEditView object informing the delegate about the editing
 * @param textViewTableViewCell The textview of textViewTableViewCell for which an editing session began
 * @param indexPath An index path locating the new selected row in contactEditTableView
 */
- (void)contactEditView:(ContactEditView *)contactEditView ppTextViewTableViewCellDidChange:(PPTextViewTableViewCell *)textViewTableViewCell atIndexPath:(NSIndexPath *)indexPath;


/**
 鍵盤上方bar按鈕觸發

 @param contactEditView 編輯視圖
 @param contactEditKeyboardToolBarView 鍵盤上方視圖
 @param ppButton 按鈕
 @param controlEvent 按鈕事件
 */
- (void)contactEditView:(ContactEditView *)contactEditView contactEditKeyboardToolBarView:(ContactKeyboardToolBarView *)contactEditKeyboardToolBarView ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent;

@optional

- (void)contactEditViewDidScroll:(ContactEditView *)contactEditView;

/**
 * The touch event occurs on the contactEditView
 * @param contactEditView A contactEditView object informing the delegate about the touch event occuring
 */
- (void)contactEditViewDidTouch:(ContactEditView *)contactEditView;


/**
 * Asks the delegate if editing should begin in the specified text field
 * @param contactEditView A contactEditView object informing the delegate about the should begin editing
 * @param multipleTextFieldButtonTableViewCell The textfield of multipleTextFieldButtonTableViewCell for which an editing session began
 * @param tag The tag of textfield
 * @param indexPath An index path locating the new selected row in contactEditTableView
 * @return: If return YES, the specified text field should begin editting.
 */
- (BOOL)contactEditView:(ContactEditView *)contactEditView ppMultipleTextFieldButtonTableViewCellShouldBeginEditing:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldButtonTableViewCell textFieldTag:(NSUInteger)tag atIndexPath:(NSIndexPath *)indexPath;


- (BOOL)contactEditView:(ContactEditView *)contactEditView ppHeadImageNameTableViewCellShouldBeginEditing:(PPHeadImageNameTabelViewCell *)headImageNameTabelViewCell textFieldTag:(NSUInteger)tag atIndexPath:(NSIndexPath *)indexPath;

/**
 * Asks the delegate if editing should begin in the specified text field
 * @param contactEditView A contactEditView object informing the delegate about the should begin editing
 * @param phoneTextFieldTableViewCell The textfield of phoneTextFieldTableViewCell for which an editing session began
 * @param indexPath An index path locating the new selected row in contactEditTableView
 * @return: If return YES, the specified text field should begin editting.
 */
- (BOOL)contactEditView:(ContactEditView *)contactEditView ppPhoneTextFieldTableViewCellShouldBeginEditing:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath;


/**
 * Asks the delegate if editing should begin in the specified text field
 * @param contactEditView A contactEditView object informing the delegate about the should begin editing
 * @param textFieldTableViewCell The textfield of textFieldTableViewCell for which an editing session began
 * @param indexPath An index path locating the new selected row in contactEditTableView
 * @return: If return YES, the specified text field should begin editting.
 */
- (BOOL)contactEditView:(ContactEditView *)contactEditView ppTextFieldTableViewCellShouldBeginEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath;


/**
 * Asks the delegate if editing should begin in the specified textView
 * @param contactEditView A contactEditView object informing the delegate about the should begin editing
 * @param textViewTableViewCell The textView of textViewTableViewCell for which an editing session began
 * @param indexPath An index path locating the new selected row in contactEditTableView
 * @return: If return YES, the specified textView should begin editting.
 */
- (BOOL)contactEditView:(ContactEditView *)contactEditView ppTextViewTableViewCellShouldBeginEditing:(PPTextViewTableViewCell *)textViewTableViewCell atIndexPath:(NSIndexPath *)indexPath;



/**
 TextView is in tableViewCell did end editing
 
 @param contactEditView 委託者
 @param textViewTableViewCell cell欄位
 @param indexPath 選項
 */
- (void)contactEditView:(ContactEditView *)contactEditView ppTextViewTableViewCellDidEndEditing:(PPTextViewTableViewCell *)textViewTableViewCell atIndexPath:(NSIndexPath *)indexPath;


/**
 TextField is in tableViewCell did end editing
 
 @param contactEditView 委託者
 @param textFieldTableViewCell cell欄位
 @param indexPath 選項
 */
- (void)contactEditView:(ContactEditView *)contactEditView ppTextFieldTableViewCellDidEndEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath;


/**
 Phone TextField is in tableViewCell did end editing
 
 @param contactEditView 委託者
 @param phoneTextFieldTableViewCell cell欄位
 @param indexPath 選項
 */
- (void)contactEditView:(ContactEditView *)contactEditView ppPhoneTextFieldTableViewCellDidEndEditing:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath;


/**
 MultipleTextField is in tableViewCell did end editing
 
 @param contactEditView 委託者
 @param multipleTextFieldButtonTableViewCell cell 欄位
 @param tag 對應的tag
 @param indexPath 選項
 */
- (void)contactEditView:(ContactEditView *)contactEditView ppMultipleTextFieldButtonTableViewCellDidEndEditing:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldButtonTableViewCell textFieldTag:(NSUInteger)tag atIndexPath:(NSIndexPath *)indexPath;



- (CGFloat)contactEditView:(ContactEditView *)contactEditView estimatedHeightForRowAtIndexPath:(NSIndexPath *)indexPath;

/**
 * Asks the delegate for the height to use for a row in a specified location
 * @param contactEditView The contactEditView object requesting this information.
 * @param indexPath An index path that locates a row in contactEditTableView
 * @return: A nonnegative floating-point value that specifies the height (in points) that row should be
 */
- (CGFloat)contactEditView:(ContactEditView *)contactEditView heightForRowAtIndexPath:(NSIndexPath *)indexPath;


/**
 * Asks the delegate for the editing style of a row at a particular location in a contactEditTableView.
 * @param contactEditView An object representing the table view requesting this information.
 * @param indexPath An index path locating the new selected row in contactEditTableView
 * @return: The UITableViewCellEditingStyle of selected row
 */
- (UITableViewCellEditingStyle)contactEditView:(ContactEditView *)contactEditView editingStyleForRowAtIndexPath:(NSIndexPath *)indexPath;

/**
 *  Ask the delegate for the row can move or no
 *  @param contactEditView An object representing the table view requesting this information.
 *  @param indexPath An index path locating the row in contactEditTableView
 *  @return: YES or No
 */
- (BOOL)contactEditView:(ContactEditView *)contactEditView canMoveRowAtIndexPath:(NSIndexPath *)indexPath;

/**
 *  Ask the delegate for the row moving from sourceIndexPath to proposedDestinationIndexPath
 *  @param contactEditView An object representing the table view requesting this information.
 *  @param sourceIndexPath An source indexPath in contactEditTableView
 *  @param proposedDestinationIndexPath An proposedDestination indexPath in contactEditTableView
 *  @return : An final destination indexPath in contactEditTableView
 */
- (NSIndexPath *)contactEditView:(ContactEditView *)contactEditView targetIndexPathForMoveFromRowAtIndexPath:(NSIndexPath *)sourceIndexPath toProposedIndexPath:(NSIndexPath *)proposedDestinationIndexPath;

/**
 *  Tells the delegate for the row moving from source indexPath to target indexPath
 *  @param contactEditView An object representing the table view requesting this information.
 *  @param sourceIndexPath An index path locating the old indexPath in contactEditTableView
 *  @param destinationIndexPath An index path locating the new indexPath in contactEditTableView
 */
- (void)contactEditView:(ContactEditView *)contactEditView moveRowAtIndexPath:(NSIndexPath *)sourceIndexPath toIndexPath:(NSIndexPath *)destinationIndexPath;

/**
 * Tells the delegate that editing began for the specified text field
 * @param contactEditView A contactEditView object informing the delegate about the begin editing
 * @param multipleTextFieldButtonTableViewCell The textfield of multipleTextFieldButtonTableViewCell for which an editing session began
 * @param tag The tag of textfield
 * @param indexPath An index path locating the new selected row in contactEditTableView
 */
- (void)contactEditView:(ContactEditView *)contactEditView ppMultipleTextFieldButtonTableViewCellDidBeginEditing:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldButtonTableViewCell textFieldTag:(NSUInteger)tag atIndexPath:(NSIndexPath *)indexPath;

- (void)contactEditView:(ContactEditView *)contactEditView ppHeadImageNameTableViewCellDidBeginEditing:(PPHeadImageNameTabelViewCell *)headImageNameTabelViewCell textFieldTag:(NSUInteger)tag atIndexPath:(NSIndexPath *)indexPath;

/**
 * Tells the delegate that editing began for the specified text field
 * @param contactEditView A contactEditView object informing the delegate about the begin editing
 * @param phoneTextFieldTableViewCell The textfield of phoneTextFieldTableViewCell for which an editing session began
 * @param indexPath An index path locating the new selected row in contactEditTableView
 */
- (void)contactEditView:(ContactEditView *)contactEditView ppPhoneTextFieldTableViewCellDidBeginEditing:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath;


/**
 * Tells the delegate that editing began for the specified text field
 * @param contactEditView A contactEditView object informing the delegate about the begin editing
 * @param textFieldTableViewCell The textfield of textFieldTableViewCell for which an editing session began
 * @param indexPath An index path locating the new selected row in contactEditTableView
 */
- (void)contactEditView:(ContactEditView *)contactEditView ppTextFieldTableViewCellDidBeginEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath;


/**
 * Tells the delegate that editing began for the specified textView
 * @param contactEditView A contactEditView object informing the delegate about the begin editing
 * @param textViewTableViewCell The textView of textViewTableViewCell for which an editing session began
 * @param indexPath An index path locating the new selected row in contactEditTableView
 */
- (void)contactEditView:(ContactEditView *)contactEditView ppTextViewTableViewCellDidBeginEditing:(PPTextViewTableViewCell *)textViewTableViewCell atIndexPath:(NSIndexPath *)indexPath;


- (void)contactEditView:(ContactEditView *)contactEditView ppMultipleTextFieldButtonTableViewCellTouchDetail:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldButtonTableViewCell textFieldTag:(NSUInteger)tag atIndexPath:(NSIndexPath *)indexPath;


- (void)contactEditView:(ContactEditView *)contactEditView ppHeadImageNameTableViewCellDidChanged:(PPHeadImageNameTabelViewCell *)headImageNameTabelViewCell textFieldTag:(NSUInteger)tag atIndexPath:(NSIndexPath *)indexPath;


- (void)contactEditView:(ContactEditView *)contactEditView ppHeadImageNameTableViewCellTouchDetail:(PPHeadImageNameTabelViewCell *)headImageNameTabelViewCell textFieldTag:(NSUInteger)tag atIndexPath:(NSIndexPath *)indexPath;


- (void)contactEditView:(ContactEditView *)contactEditView ppHeadImageNameTableViewCell:(PPHeadImageNameTabelViewCell *)headImageNameTabelViewCell
               ppButton:(PPButton *)ppButton
           controlEvent:(UIControlEvents)controlEvent;

- (UIView *)contactEditView:(ContactEditView *)contactEditView viewForHeaderInSection:(NSInteger)section;

- (CGFloat)contactEditView:(ContactEditView *)contactEditView heightForHeaderInSection:(NSInteger)section;

- (void)contactEditView:(ContactEditView *)contactEditView willDisplayCell:(UITableViewCell *)cell forRowAtIndexPath:(NSIndexPath *)indexPath;

- (BOOL)contactEditViewTableViewCellShowReturn;


@end
