//
//  ContactEditHeaderView.h
//  Pods
//
//  Created by Howard on 2015/6/29.
//
//

#import <UIKit/UIKit.h>

// View
#import "PPButton.h"
#import "PPImageScrollView.h"

// Category
#import "ContactImageProtocol.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Parameter Define

typedef NS_ENUM(NSUInteger, ContactEditHeaderViewAction)
{
    ContactEditHeaderViewAction_CardImage = 0,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Protocol

@class ContactEditHeaderView;

@protocol ContactEditHeaderViewDelegate <NSObject>

@required

/**
 *  連絡人編輯上方視圖動作委託
 *
 *  @param contactEditHeaderView 委托者
 *  @param responderView         觸發者
 *  @param action                動作
 */
- (void)contactEditHeaderView:(ContactEditHeaderView *)contactEditHeaderView responderView:(UIView *)responderView action:(ContactEditHeaderViewAction)action;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactEditHeaderView Interface

@interface ContactEditHeaderView : UIView <ContactImageProtocol>

@property (nonatomic,assign) id<ContactEditHeaderViewDelegate> delegate;
@property (nonatomic,retain) PPImageScrollView                 *contactCardScrollView;
@property (nonatomic,retain) UIView                            *contactCardMaskView;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 *  是否呈現名片影像loading畫面
 *
 *  @param visible YES->呈現
 */
- (void)cardImageIndicatorViewVisible:(BOOL)visible;


/**
 *  設定大頭貼
 *
 *  @param contactHeadImage 大頭貼
 */
- (void)setContactHeadImage:(UIImage *)contactHeadImage;


/**
 *  設定前名片圖
 *
 *  @param contactFrontCardImage 前名片圖
 */
- (void)setContactFrontCardImage:(UIImage *)contactFrontCardImage;


/**
 *  設定後名片圖
 *
 *  @param contactRearCardImage 後名片圖
 */
- (void)setContactRearCardImage:(UIImage *)contactRearCardImage;


/**
 *  設定遮罩的透明度，並進行額外的設定
 *
 *  @param colorAlpha 遮罩頁面的透明度
 */
- (void)setContactCardMaskAlpha:(CGFloat)colorAlpha;


@end
