//
//  WCCaptureViewController+ResourceDefine.h
//
//  !! 因為是給內部使用，所以prefix用物件名稱縮寫。
//     如果是給外部使用，prefix還是要用完整物件名稱。
//

// 測試用dump log
//#define _DUMP_LOG_

#ifndef WCCaptureViewController_ResourceDefine_h
#define WCCaptureViewController_ResourceDefine_h

#import <UIKit/UIKit.h>
#import "NSString+Additions.h"
#import "WCAppearanceDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#define WCCVC                                       @"WCCaptureViewController"

////////////////////////////////////////////////////////////////////////////////////////////////////
// Multiple language string

// !! 共用的字串由app的字串檔取得
#define WCCVC_MLS_Ok                                [@"MLS_Ok" localized]
#define WCCVC_MLS_Cancel                            [@"MLS_Cancel" localized]
#define WCCVC_MLS_Close                             [@"MLS_Close" localized]
#define WCCVC_MLS_CameraPolicyFailed                [@"MLS_CameraPolicyFailed" localized]

// !! 專屬的字串由元件的字串檔取得

#define WCCVC_MLS_ManualCapture                     [@"MLS_ManualCapture" localizedFromTable:WCCVC]
#define WCCVC_MLS_DockingCapture                    [@"MLS_DockingCapture" localizedFromTable:WCCVC]
#define WCCVC_MLS_QRCodeCapture                     [@"MLS_QRCodeCapture" localizedFromTable:WCCVC]

#define WCCVC_MLS_FlashOn                           [@"MLS_EnableCameraFlash" localizedFromTable:WCCVC]
#define WCCVC_MLS_FlashOff                          [@"MLS_DisableCameraFlash" localizedFromTable:WCCVC]
#define WCCVC_MLS_TorchOn                           [@"MLS_EnableCameraTorch" localizedFromTable:WCCVC]
#define WCCVC_MLS_TorchOff                          [@"MLS_DisableCameraTorch" localizedFromTable:WCCVC]
#define WCCVC_MLS_ImageEnhanceOn                    [@"MLS_EnableEnhanceImage" localizedFromTable:WCCVC]
#define WCCVC_MLS_ImageEnhanceOff                   [@"MLS_DisableEnhanceImage" localizedFromTable:WCCVC]
#define WCCVC_MLS_AutoCropOn                        [@"MLS_AutoCropOn" localizedFromTable:WCCVC]
#define WCCVC_MLS_AutoCropOff                       [@"MLS_AutoCropOff" localizedFromTable:WCCVC]
#define WCCVC_MLS_SingleSide                        [@"MLS_SingleSideRecog" localizedFromTable:WCCVC]
#define WCCVC_MLS_DoubleSide                        [@"MLS_DoubleSideRecog" localizedFromTable:WCCVC]
#define WCCVC_MLS_Guide                             [@"MLS_Guide" localizedFromTable:WCCVC]

#define WCCVC_MLS_RecogLang                         [@"MLS_RecogLang" localizedFromTable:WCCVC]

#define WCCVC_MLS_DetectingQRCode                   [@"MLS_DetectingQRCode" localizedFromTable:WCCVC]
#define WCCVC_MLS_SwitchToManual                    [@"MLS_SwitchToManual" localizedFromTable:WCCVC]
#define WCCVC_MLS_AutoSingleSidePutFront            [@"MLS_AutoSingleSidePutFront" localizedFromTable:WCCVC]
#define WCCVC_MLS_AutoDoubleSidePutFront            [@"MLS_AutoDoubleSidePutFront" localizedFromTable:WCCVC]
#define WCCVC_MLS_AutoDoubleSidePutBack             [@"MLS_AutoDoubleSidePutBack" localizedFromTable:WCCVC]
#define WCCVC_MLS_ManualSingleSidePutFront          [@"MLS_ManualSingleSidePutFront" localizedFromTable:WCCVC]
#define WCCVC_MLS_ManualDoubleSidePutFront          [@"MLS_ManualDoubleSidePutFront" localizedFromTable:WCCVC]
#define WCCVC_MLS_ManualDoubleSidePutBack           [@"MLS_ManualDoubleSidePutBack" localizedFromTable:WCCVC]
#define WCCVC_MLS_SingleSideRemoveFront             [@"MLS_SingleSideRemoveFront" localizedFromTable:WCCVC]
#define WCCVC_MLS_DoubleSideRemoveFront             [@"MLS_DoubleSideRemoveFront" localizedFromTable:WCCVC]
#define WCCVC_MLS_DoubleSideRemoveBack              [@"MLS_DoubleSideRemoveBack" localizedFromTable:WCCVC]
#define WCCVC_MLS_SkipBackSide                      [@"MLS_SkipBackSide" localizedFromTable:WCCVC]
#define WCCVC_MLS_RemoveCard                        [@"MLS_RemoveCard" localizedFromTable:WCCVC]
#define WCCVC_MLS_ManualMode                        [@"MLS_ManualMode" localizedFromTable:WCCVC]

#define WCCVC_MLS_GuideFlashTitle                   [@"MLS_GuideFlashTitle" localizedFromTable:WCCVC]
#define WCCVC_MLS_GuideFlashMessage                 [@"MLS_GuideFlashMessage" localizedFromTable:WCCVC]
#define WCCVC_MLS_GuideImageEnhanceTitle            [@"MLS_GuideImageEnhanceTitle" localizedFromTable:WCCVC]
#define WCCVC_MLS_GuideImageEnhanceMessage          [@"MLS_GuideImageEnhanceMessage" localizedFromTable:WCCVC]
#define WCCVC_MLS_GuideAutoCropTitle                [@"MLS_GuideAutoCropTitle" localizedFromTable:WCCVC]
#define WCCVC_MLS_GuideAutoCropMessage              [@"MLS_GuideAutoCropMessage" localizedFromTable:WCCVC]
#define WCCVC_MLS_GuideDoubleSideTitle              [@"MLS_GuideDoubleSideTitle" localizedFromTable:WCCVC]
#define WCCVC_MLS_GuideDoubleSideMessage            [@"MLS_GuideDoubleSideMessage" localizedFromTable:WCCVC]

#define WCCVC_MLS_NeedToBuyDock                     [@"MLS_NeedToBuyDock" localizedFromTable:WCCVC]
#define WCCVC_MLS_HasBoughtDock                     [@"MLS_HasBoughtDock" localizedFromTable:WCCVC]
#define WCCVC_MLS_MoreDockInfo                      [@"MLS_MoreDockInfo" localizedFromTable:WCCVC]


////////////////////////////////////////////////////////////////////////////////////////////////////
// Image file prefix

#define WCCVC_IFP_FlashButton                       @"WCMCC_Flash"
#define WCCVC_IFP_TorchButton                       @"WCMCC_Torch"
#define WCCVC_IFP_ImageEnhanceButton                @"WCMCC_ImageEnhance"
#define WCCVC_IFP_AutoCropButton                    @"WCMCC_AutoCrop"
#define WCCVC_IFP_DoubleSideButton                  @"WCMCC_DoubleSide"
#define WCCVC_IFP_GuideButton                       @"WCMCC_Guide"
#define WCCVC_IFP_CaptureButton                     @"WCMCC_Capture"
#define WCCVC_IFP_CancelButton                      @"WCMCC_Cancel"
#define WCCVC_IFP_DoneButton                        @"WCMCC_Done"
#define WCCVC_IFP_SkipButton                        @"WCMCC_Skip"

#define WCCVC_IFP_CardDirectionLandscape            @"WCMCC_CardDirectionLandscapeFrontSide"
#define WCCVC_IFP_CardDirectionLandscapeBackSide    @"WCMCC_CardDirectionLandscapeBackSide"
#define WCCVC_IFP_CardDirectionLandscapeFrontSide   @"WCMCC_CardDirectionLandscapeFrontSide"

#define WCCVC_IFP_CardDirectionPortrait             @"WCMCC_CardDirectionPortraitFrontSide"
#define WCCVC_IFP_CardDirectionPortraitBackSide     @"WCMCC_CardDirectionPortraitBackSide"
#define WCCVC_IFP_CardDirectionPortraitFrontSide    @"WCMCC_CardDirectionPortraitFrontSide"



////////////////////////////////////////////////////////////////////////////////////////////////////
// Layout Design

#define WCCVC_LD_ImageScale                         3.0

#define WCCVC_LD_SettingsBarAlpha                   0.75
#define WCCVC_LD_SettingsBarHeight                  44.0
#define WCCVC_LD_CaptureBarHeight                   60.0
#define WCCVC_LD_ScrollMenuBarHeight                40.0

#define WCCVC_LD_DarkBlueColor                      WCAppearanceDefine_DarkBlueColor
#define WCCVC_LD_LightBlueColor                     WCAppearanceDefine_LightBlueColor
#define WCCVC_LD_OrangeColor                        WCAppearanceDefine_OrangeColor
#define WCCVC_LD_CornerRadius                       WCAppearanceDefine_CornerRadius
#define WCCVC_LD_SettingsBarImageEdgeInset          WCAppearanceDefine_ButtonImageEdgeInset
#define WCCVC_LD_CaptureBarImageEdgeInset           UIEdgeInsetsMake(6, 6, 6, 6)
#define WCCVC_LD_CaptureBarTitleEdgeInset           UIEdgeInsetsMake(2, 2, 2, 2)

#define WCCVC_LD_TargetBoxLineWidth                 2.0
#define WCCVC_LD_TargetBoxLineLength                20.0
#define WCCVC_LD_UnfixedTargetBoxMargin             12.0
#define WCCVC_LD_UnfixedTargetBoxMargin_iPhone13    45.0
#define WCCVC_LD_QRCodeTargetBoxRatio               0.75
#define WCCVC_LD_CaptureCountLabelOffset            CGPointMake(16.0, -10.0)

/// 目前沒有比較好的做法，先用固定值。
#define WCCVC_LD_InfoLabelMaxSize                   CGSizeMake(250, 100)


////////////////////////////////////////////////////////////////////////////////////////////////////
// Guide

#define WCCVC_ManualCaptureGuide                    @"WCCVC_ManualCaptureGuide"
#define WCCVC_DockingCaptureGuide                   @"WCCVC_DockingCaptureGuide"


#endif
