//
//  CVCScrollMenu.h
//

#import <UIKit/UIKit.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

@class CVCScrollMenu;

@protocol CVCScrollMenuDelegate <NSObject>

@optional

/**
 * Menu will begin scroll
 *
 * @param scrollMenu - CVCScrollMenu instance
 * @param toIndex - New index that will be displayed in center
 */
- (void)scrollMenu:(CVCScrollMenu *)scrollMenu willScrollToIndex:(NSInteger)toIndex;

@end




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPScrollBarView()

@interface CVCScrollMenu : UIView 

/// Delegate
@property (nonatomic, assign) id<CVCScrollMenuDelegate> proxy;

/// Menu item titles
@property (nonatomic, retain) NSMutableArray *itemTitles;

/// 當前menu所選擇選項的Index,從0開始
@property (nonatomic, assign) NSInteger currentIndex;

/**
 * Initialize
 *
 * @return CVCScrollMenu instance
 */
- (id)init;


/**
 * Scroll to right side item
 */
- (void)scrollToRightSideItem;


/**
 * Scroll to left side item
 */
- (void)scrollToLeftSideItem;


/**
 * Move to specified item
 *
 * @param index - Item index
 */
- (void)moveToItemIndex:(NSInteger)index;

@end
