//
//  WCCSVDataController+ParameterDefine.h
//  
//
//  Created by Howard on 2016/11/18.
//
//

#ifndef WCCSVDataController_ParameterDefine_h
#define WCCSVDataController_ParameterDefine_h


////////////////////////////////////////////////////////////////////////////////////////////////////
/// Error code of WCCSVDataController

typedef NS_OPTIONS(NSInteger, WCCSVDataController_Error)
{
    WCCSVDataController_Error_Unknown = 0,
    WCCSVDataController_Error_NoCardToWrite,
    WCCSVDataController_Error_MustHaveDelegateMethod,
    WCCSVDataController_Error_FailedToInitObject,
    WCCSVDataController_Error_FailedToOpenFileForWriting,
    WCCSVDataController_Error_FailedToWriteCardInfo,
    WCCSVDataController_Error_NoFileToRead,
    WCCSVDataController_Error_FailedToOpenFileForReading,
    WCCSVDataController_Error_FailedToReadFileInfo,
    WCCSVDataController_Error_FailedToParseFileInfo,
    WCCSVDataController_Error_FailedToTransformCardModel,
};



////////////////////////////////////////////////////////////////////////////////////////////////////
/// data format

typedef NS_OPTIONS(NSInteger, WCCSVDataController_Format)
{
    WCCSVDataController_Format_None = 0,
    WCCSVDataController_Format_UTF8,
    WCCSVDataController_Format_UTF16,
    WCCSVDataController_Format_iWorks,
    WCCSVDataController_Format_WindowsExcel,
    WCCSVDataController_Format_Gmail,
    WCCSVDataController_Format_Outlook,
};


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Import CSV Field

typedef NS_ENUM(NSInteger,WCCSV_FieldType)
{
    WCCSV_FieldType_CreateTime = -1,
    WCCSV_FieldType_ModifyTime = -2,
    WCCSV_FieldType_CateogryID = -3
};


#endif /* WCCSVDataController_ParameterDefine_h */
