//
//  PPCSVData.h
//  WorldCardMobile
//
//@HPPAN@V01;10076;WorldCardMobile_JP_4.0.0;HARRY;20120210;SPEC;bug fix : 匯出成gmail_csv檔案，再匯入到google mail聯絡人中，沒有顯示姓名讀音欄位

//  Created by harry on 2011/6/29.
//  Copyright 2011年 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>


#import "PPCSVDataDefinition.h"

#define KPPCSV_LABEL_CommonType_Work                   @"Work"
#define KPPCSV_LABEL_CommonType_Home                   @"Home"
#define KPPCSV_LABEL_CommonType_Other                  @"Other"

#define KPPCSV_LABEL_Name                              @"Name"

#define KPPCSV_LABEL_FirstName                         @"First"
#define KPPCSV_LABEL_LastName                          @"Last"
#define KPPCSV_LABEL_FirstPhonetic                     @"First Phonetic"
#define KPPCSV_LABEL_LastPhonetic                      @"Last Phonetic"
#define KPPCSV_LABEL_AdditionalName                    @"Middle"
#define KPPCSV_LABEL_NamePrefix                        @"Prefix"
#define KPPCSV_LABEL_NameSuffix                        @"Suffix"


#define KPPCSV_LABEL_Company                           @"Organization"
#define KPPCSV_LABEL_Company_Name                      @"Company"
#define KPPCSV_LABEL_Company_Title                     @"Job Title"
#define KPPCSV_LABEL_Company_Department                @"Department"
#define KPPCSV_LABEL_Company_YomiCompany               @"Company Phonetic"

#define KPPCSV_LABEL_Phone                             @"Phone"
#define KPPCSV_LABEL_PhoneType_Mobile                  @"Mobile"
#define KPPCSV_LABEL_PhoneType_Work                    @"Work"
#define KPPCSV_LABEL_PhoneType_Home                    @"Home"
#define KPPCSV_LABEL_PhoneType_Main                    @"Main"
#define KPPCSV_LABEL_PhoneType_WorkFax                 @"Work Fax"
#define KPPCSV_LABEL_PhoneType_HomeFax                 @"Home Fax"
#define KPPCSV_LABEL_PhoneType_Pager                   @"Pager"
#define KPPCSV_LABEL_PhoneType_Other                   @"Other"
#define KPPCSV_LABEL_PhoneType_iPhone                  @"iPhone"
#define KPPCSV_LABEL_PhoneType_GoogleVoice             @"Google Voice"



//Email
//  Home, Work, Other
#define KPPCSV_LABEL_Email                             @"E-mail"

//Website
//  Homepage, Home, Work, Other
#define KPPCSV_LABEL_URL                               @"Website"
#define KPPCSV_LABEL_URLType_Homepage                  @"Homepage"
#define KPPCSV_LABEL_URLType_Blog                      @"Blog"
#define KPPCSV_LABEL_URLType_Profile                   @"Profile"

//IM
#define KPPCSV_LABEL_IM                                @"InstantMessage"
#define KPPCSV_LABEL_IMType_GoogleTalk                 @"Google Talk"
#define KPPCSV_LABEL_IMType_Aim                        @"AIM"
#define KPPCSV_LABEL_IMType_Yahoo                      @"Yahoo"
#define KPPCSV_LABEL_IMType_Skype                      @"Skype"
#define KPPCSV_LABEL_IMType_QQ                         @"QQ"
#define KPPCSV_LABEL_IMType_MSN                        @"MSN"
#define KPPCSV_LABEL_IMType_ICQ                        @"ICQ"
#define KPPCSV_LABEL_IMType_Jabber                     @"Jabber"
#define KPPCSV_LABEL_IMType_GaduGadu                   @"GaduGadu"
#define KPPCSV_LABEL_IMType_Other                      @"Other"

//Date
#define KPPCSV_LABEL_Birthday                          @"Birthday"
#define KPPCSV_LABEL_Event                             @"Event"
#define KPPCSV_LABEL_EventType_Anniversary             @"Anniversary"

//Address
//  Home, Work, Other
#define KPPCSV_LABEL_Address                           @"Address"
#define KPPCSV_LABEL_Address_Street                    @"Street"
#define KPPCSV_LABEL_Address_City                      @"City"
#define KPPCSV_LABEL_Address_State                     @"State"
#define KPPCSV_LABEL_Address_ZIP                       @"ZIP"
#define KPPCSV_LABEL_Address_Country                   @"Country"


//NickName
#define KPPCSV_LABEL_NickName                          @"Nickname"
//Note
#define KPPCSV_LABEL_Notes                             @"Notes"

@interface PPCSVData : NSObject {
    
    NSMutableDictionary* _mutableDictionary;
    
    NSMutableDictionary* _fieldKeyUseCount;     // 記錄key使用過幾次，沒有表示是第一次使用 (key<NSString *>:value<NSNumber *>)
    
    NSMutableArray* _mutableFieldKeyArray;

    
    //@IPPAN@V01;10076
    BOOL            _bPhoneticNameFieldEnabled;
}

//================================================
//  Private Methods
//================================================
- (void)pp_initialize_CSV_dictionary;
- (NSInteger)pp_getFieldDataMaxCountWithKey:(NSString*)aFieldKey;
- (NSInteger)pp_getFieldDataCurrentCountWithKey:(NSString*)aFieldKey;

- (NSString*)pp_getFieldBaseDisplayNameWithKey:(NSString*)aFieldKey;
- (NSString*)pp_getFieldDataWithKey:(NSString*)aFieldKey withIndex:(NSInteger)aIndex;

//================================================
//  Public Methods
//================================================
- (id)initWithContactTemplateModel;


- (void)addOneItem:(NSString*)aItemText forKey:(NSString*)aFieldKey;
- (BOOL)isFieldFull:(NSString*)aFieldKey;

- (NSArray *)newCSVTitleArrayForWriter;
- (NSArray *)newCSVDataArrayForWriter:(BOOL)aIsForExcel;

- (NSArray *)newOutlookCSVTitleArrayForWriter;
- (NSArray *)newOutlookCSVDataArrayForWriter;

- (NSArray *)newGmailCSVTitleArrayForWriter;
- (NSArray *)newGmailCSVDataArrayForWriter;

- (void)enablePhoneticNameField:(BOOL)bEnabled;

//-(void)printData;

@end
