//
//  ABDCSourceController.h
//
//

#import <Foundation/Foundation.h>
#import <Contacts/Contacts.h>
#import "WCABSourceModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef void (^ABDCSC_Result)(BOOL result);

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ABDCSC_SourceInfoModel : NSObject

@property (nonatomic, assign) CNContactType type;
@property (nonatomic, assign) NSString * sourceID;
@property (nonatomic, retain) NSString  *sourceName;
@property (nonatomic, retain) NSString  *displayName;
@property (nonatomic, retain) NSString  *host;
@property (nonatomic, retain) NSString  *prop5Value;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ABDCSourceController : NSObject

@property (nonatomic, retain) CNContactStore *contactStore;

- (NSString *)defaultSourceID;

- (BOOL)isSourceExist:(NSString *)sourceID;

- (NSMutableArray *)copyAllSourcesAndGroups;

- (NSString *)displayNameWithSourceID:(NSString *)sourceID
                              groupID:(NSString *)groupID;

- (WCABSourceModel *)sourceModelWithSourceID:(NSString *)sourceID;

@end
