//
//  PPSyncActionModel.h
//  
//
//  Created by Mike Shih on 11/11/22.
//  Copyright (c) 2011年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PPSyncCompareModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPSyncAction)
{
    PPSyncAction_Delete = 0,
    PPSyncAction_Insert,
    PPSyncAction_Update,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPSyncTarget)
{
	PPSyncTarget_Local = 0,
	PPSyncTarget_Remote,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPSyncType)
{
    PPSyncType_Card = 0,
	PPSyncType_Group,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPSyncActionModel : NSObject
{
@protected
    PPSyncAction        action_;
    PPSyncCompareModel  *localSyncCompareModel_;
    PPSyncCompareModel  *remoteSyncCompareModel_;
    PPSyncTarget        target_;
    PPSyncType          type_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,assign) PPSyncAction        action;
@property(nonatomic,retain) PPSyncCompareModel  *localSyncCompareModel;
@property(nonatomic,retain) PPSyncCompareModel  *remoteSyncCompareModel;
@property(nonatomic,assign) PPSyncTarget        target;
@property(nonatomic,assign) PPSyncType          type;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (NSComparisonResult)compare:(PPSyncActionModel *)ppSyncActionModel;

@end
