//
//  PPStorageSpaceSelectSectionController.h
//  Pods
//
//  Created by Howard on 2015/8/3.
//
//

#import "PPSectionController.h"
#import "PPCloud.h"

// define
#import "PPStorageSpaceSelectViewController+PrivateParameterDefine.h"

@interface PPStorageSpaceSelectSectionController : PPSectionController

@property (nonatomic, retain) NSString *exchangeServerName;
////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 *  判斷是否讀取帳號資訊
 *
 *  @param row 對應的cell
 *
 *  @return YES, 連結
 */
- (BOOL)needFetchAccoutInfoWithRow:(NSUInteger)row;

/**
 *  刷新預設資訊
 */
- (void)fetchDefaultDataWithSpaceTypes:(NSArray *)spaceTypes;

/**
 *  刷新空間資訊
 *
 *  @param storageSpaceSelectSectionControllerRow 對應的cell
 */
- (void)fetchNeedFetchAccoutInfoWithPPStorageSpaceSelectSectionControllerRow:(PPStorageSpaceSelectSectionControllerRow)storageSpaceSelectSectionControllerRow;

/**
 *  刷新空間帳號資訊
 *
 *  @param storageSpaceSelectSectionControllerRow 對應的cell
 *  @param cloudAccountInfo      帳號資訊
 */
- (void)fetchAccountInfoWithStorageSpaceSelectSectionControllerRow:(PPStorageSpaceSelectSectionControllerRow)storageSpaceSelectSectionControllerRow cloudAccountInfo:(PPCloudAccountInfo *)cloudAccountInfo;


- (NSUInteger)indexPathRowForStorageSpaceSelectSectionControllerRow:(PPStorageSpaceSelectSectionControllerRow)storageSpaceSelectSectionControllerRow;

@end
