//
//  PPSideMenuController.h
//  Pods
//
//  Created by sanhue on 2015/6/11.
//
//

#import <UIKit/UIKit.h>
#import "PPViewController.h"

typedef NS_ENUM (NSInteger, PPSideMenuState)
{
    PPSideMenuState_CenterVisible = 1,
    PPSideMenuState_LeftVisible,
    PPSideMenuState_RightVisible
};

@class PPSideMenuController;

@protocol PPSideMenuControllerDelegate <NSObject>
@optional
- (void)sideMenuControllerDidShowLeftPanel:(PPSideMenuController *)sideMenuController;
- (void)sideMenuControllerDidShowRightPanel:(PPSideMenuController *)sideMenuController;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 * 一個可包含左，中，右 三個ViewController的container,
 * 預設顯示中間的View controller, 可用手勢來開關左右兩個view controller
 */
@interface PPSideMenuController : PPViewController

@property (nonatomic, assign) id<PPSideMenuControllerDelegate> delegate;
////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - controller state

/// current state
@property(nonatomic, readonly) PPSideMenuState state;

/// 目前顯示的view controller
@property (nonatomic, readonly) UIViewController *visibleViewController;

/// size the left side menu based on % of total screen width
@property (nonatomic, assign) CGFloat leftGapPercentage;
/// size the right side menu based on % of total screen width
@property (nonatomic, assign) CGFloat rightGapPercentage;

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - controller settings

/// 設定左邊Panel是否可以手勢開啟，default YES
@property (nonatomic, assign) BOOL enableLeftPanToOpen;

/// 設定右邊Panel是否可以手勢開啟，default YES
@property (nonatomic, assign) BOOL enableRightPanToOpen;

/// 設定為強制直式，如果是顯示在splitview中，永遠都算直式，defualt NO;
@property (nonatomic, assign) BOOL portraitOnly;
////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - gesture instance

/// 回傳center panel用來控制手勢的gesture, 負責左右兩個panel的開關
@property (nonatomic, readonly) UIPanGestureRecognizer *centerPanGestureRecognizer;

/// 回傳left panel用來控制手勢的gesture, 負責left panel開啟時，在left panel上以手勢關閉
@property (nonatomic, readonly) UIPanGestureRecognizer *leftPanGestureRecognizer;

/// 回傳right panel用來控制手勢的gesture, 負責right panel開啟時，在right panel上以手勢關閉
@property (nonatomic, readonly) UIPanGestureRecognizer *rightPanGestureRecognizer;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - set panel

/// 設定center panel，至少要有center
@property(nonatomic, retain) UIViewController *centerViewController;

/// 設定left panel, 沒有設定表示沒有
@property(nonatomic, retain) UIViewController *leftViewController;

/// 設定right panel, 沒有設定表示沒有
@property(nonatomic, retain) UIViewController *rightViewController;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - panel control

/**
 * 顯示left panel
 * @param Animated 是否開啟動畫
 */
- (void)showLeftViewControllerAnimated:(BOOL)Animated;

/**
 * 顯示center panel
 * @param Animated 是否開啟動畫
 */
- (void)showCenterViewControllerAnimated:(BOOL)Animated;

/**
 * 顯示right panel
 * @param Animated 是否開啟動畫
 */
- (void)showRightViewControllerAnimated:(BOOL)Animated;

/// 以程式方式開啟或關閉left panel，如果要用可以call這個
- (void)toggleLeftViewController;

/// 以程式方式開啟或關閉right panel，如果要用按鈕控制可以call這個
- (void)toggleRightViewController;


#pragma mark - default image

/// 產生預設的按鈕icon 
+ (UIImage *)copyDefaultImage;

@end
