//
//  PPSectionIndexView.h
//

#import <UIKit/UIKit.h>
#import "PPSectionIndexModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

extern CGFloat const PPSectionIndexViewDefaultVerticalWidth;
extern CGFloat const PPSectionIndexViewDefaultHorizontalHeight;

////////////////////////////////////////////////////////////////////////////////////////////////////

/// View style
typedef NS_OPTIONS(NSInteger, PPSectionIndexViewStyle)
{
    PPSectionIndexViewStyleVertical,
    PPSectionIndexViewStyleHorizontal,

};

/// Extra title
typedef NS_OPTIONS(NSInteger, PPSectionIndexViewExtraTitle)
{
    PPSectionIndexViewExtraTitleNone = 0,
    PPSectionIndexViewExtraTitleSearch = 0x01 << 0,
};


////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPSectionIndexView;
@protocol PPSectionIndexViewDelegate <NSObject>

@optional

/**
 * Delegate when title is selected
 *
 * @param sectionIndexView  Active index view
 * @param indexTitle        Index title that is selected

 */
- (void)sectionIndexView:(PPSectionIndexView *)sectionIndexView didSelectedIndexTitle:(NSString *)indexTitle;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPSectionIndexView : UIView

/// Delegate
@property (nonatomic, assign) id<PPSectionIndexViewDelegate> delegate;

/// Layout style
@property (nonatomic, assign) PPSectionIndexViewStyle style;

/// Title font
@property (nonatomic, retain) UIFont *titleFont UI_APPEARANCE_SELECTOR;

/// Title normal color
@property (nonatomic, retain) UIColor *titleNormalColor UI_APPEARANCE_SELECTOR;

/// Title highlight color
@property (nonatomic, retain) UIColor *titleHighlightColor UI_APPEARANCE_SELECTOR;

/// Background highlight color
@property (nonatomic, retain) UIColor *backgroundHighlightColor UI_APPEARANCE_SELECTOR;

/**
 * Initialize
 *
 * @return PPSectionIndexView instance
 */
- (instancetype)init;


/**
 * Set index titles
 * use |setDisplayIndexTitles:fullIndexTitles:withExtraTitle:| to complete process
 * @param indexTitles - Array of title string
 * @param extraTitle - Estra title need to add
 */
- (void)setIndexTitles:(NSArray *)indexTitles withExtraTitle:(PPSectionIndexViewExtraTitle)extraTitle;

/**
 * Set index titles
 *
 * @param displayIndexTitles - Array of title string for display
 * @param fullIndexTitles - Array of title string for output touched event
 * @param extraTitle - Estra title need to add
 */
- (void)setDisplayIndexTitles:(NSArray *)displayIndexTitles fullIndexTitles:(NSArray *)fullIndexTitles withExtraTitle:(PPSectionIndexViewExtraTitle)extraTitle;


/**
 * Enable/Disable view
 *
 * @param enable    View will be hidden when set diabled.
 */
- (void)enableView:(BOOL)enable;

@end
