//
//  PPSQLiteDBController.h
//
//
//
//  Discription
//  -----------------------------------------------
//  Base functions for SQLite database
//
//
//  SQLite errcode (copy from sqlite3.h)
//  -----------------------------------------------
//    #define SQLITE_OK           0   /* Successful result */
//    #define SQLITE_ERROR        1   /* SQL error or missing database */
//    #define SQLITE_INTERNAL     2   /* Internal logic error in SQLite */
//    #define SQLITE_PERM         3   /* Access permission denied */
//    #define SQLITE_ABORT        4   /* Callback routine requested an abort */
//    #define SQLITE_BUSY         5   /* The database file is locked */
//    #define SQLITE_LOCKED       6   /* A table in the database is locked */
//    #define SQLITE_NOMEM        7   /* A malloc() failed */
//    #define SQLITE_READONLY     8   /* Attempt to write a readonly database */
//    #define SQLITE_INTERRUPT    9   /* Operation terminated by sqlite3_interrupt()*/
//    #define SQLITE_IOERR       10   /* Some kind of disk I/O error occurred */
//    #define SQLITE_CORRUPT     11   /* The database disk image is malformed */
//    #define SQLITE_NOTFOUND    12   /* Unknown opcode in sqlite3_file_control() */
//    #define SQLITE_FULL        13   /* Insertion failed because database is full */
//    #define SQLITE_CANTOPEN    14   /* Unable to open the database file */
//    #define SQLITE_PROTOCOL    15   /* Database lock protocol error */
//    #define SQLITE_EMPTY       16   /* Database is empty */
//    #define SQLITE_SCHEMA      17   /* The database schema changed */
//    #define SQLITE_TOOBIG      18   /* String or BLOB exceeds size limit */
//    #define SQLITE_CONSTRAINT  19   /* Abort due to constraint violation */
//    #define SQLITE_MISMATCH    20   /* Data type mismatch */
//    #define SQLITE_MISUSE      21   /* Library used incorrectly */
//    #define SQLITE_NOLFS       22   /* Uses OS features not supported on host */
//    #define SQLITE_AUTH        23   /* Authorization denied */
//    #define SQLITE_FORMAT      24   /* Auxiliary database format error */
//    #define SQLITE_RANGE       25   /* 2nd parameter to sqlite3_bind out of range */
//    #define SQLITE_NOTADB      26   /* File opened that is not a database file */
//    #define SQLITE_ROW         100  /* sqlite3_step() has another row ready */
//    #define SQLITE_DONE        101  /* sqlite3_step() has finished executing */
//
//


#import <Foundation/Foundation.h>
#import <sqlite3.h>


@interface PPSQLiteDBController : NSObject 

////////////////////////////////////////////////////////////////////////////////////////////////////

@property (atomic, readonly) NSString *dbPath;
@property (atomic, retain) NSError *lastError;
@property (atomic, assign) sqlite3 *dbHandle;

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Life cycle methods

/// Initailize
- (id)initWithPath:(NSString *)dbPath;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods (資料庫)

/// 檢查資料庫檔案是否存在
- (BOOL)isDBExist;

/// 變更資料庫檔案路徑
- (void)resetDBPath:(NSString *)dbPath;

/// 連接資料庫
- (BOOL)connectDB;

/// 中斷資料庫
- (void)disconnectDB;

/// 壓縮資料庫
- (void)compactDB;

/// table是否存在
- (BOOL)isTableExist:(NSString *)tableName;

/// index是否存在
- (BOOL)isIndexExist:(NSString *)indexName;

/// 檢查table中是否有某個欄位
- (BOOL)isColumn:(NSString *)columnName inTable:(NSString *)tableName;

/// begin transaction
- (void)beginTransaction;

/// end transaction
- (void)endTransaction;

/// commit transaction
- (BOOL)commitTransaction;

/// rollback transaction
- (void)rollbackTransaction;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods (指令操作)

/// 建立資料庫
- (BOOL)createDBWithCommands:(NSArray *)commandArray;

/// 取得最後的錯誤碼
- (NSInteger)dbErrorCode;

/// 取得最後的錯誤訊息
- (NSString *)dbErrorMessage;

/// 取得可在sql命令中使用的字串
- (NSString *)sqlString:(NSString *)input;

/// 執行sql命令
- (BOOL)runSqlCommand:(NSString *)sqlCommand;

/// 執行sql命令取得單一integer回傳值(-1代表失敗)
- (NSInteger)intResultWithSelectCommand:(NSString *)sqlCommand;

/// 執行sql命令取得單一string回傳值(nil代表不存在或失敗)
- (NSString *)stringResultWithSelectCommand:(NSString *)sqlCommand;

/// 是否有符合sql命令的資料
- (BOOL)hasRecord:(NSString *)sqlCommand;

/// table中的資料數量
- (NSInteger)recordCountInTable:(NSString*)tableName;

/// 取得數字結果
- (NSInteger)integerFromStmt:(sqlite3_stmt *)stmt column:(int)column;

/// 取得字串結果
- (NSString *)stringFromStmt:(sqlite3_stmt *)stmt column:(int)column;

/// 取得時間結果
- (NSDate *)dateFromStmt:(sqlite3_stmt *)stmt column:(int)column;

@end
