//
//  PromotionViewController.h
//  Worldictionary
//
//  Created by sanhue cheng on 13/3/26.
//
//

#import <UIKit/UIKit.h>
#import "PPViewController.h"
#import "PPButton.h"

enum
{
    PPPromotionButtonID_Close =0,
    PPPromotionButtonID_Remind,
};

typedef enum
{
    PromotionStyle_Remind = 0,
    PromotionStyle_NoRemind
}PromotionStyle;

typedef void (^PromotionCompletionHandler)(NSInteger buttonID);

/////////////////////////////////////////////////////////////////////////////////////////

@interface PPPromotionViewController : PPViewController <PPButtonDelegate>

/////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - property

@property (nonatomic, assign)PromotionStyle     promotionStyle;

/////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - instance methods

- (id)initWithURL:(NSURL*)url completion:(PromotionCompletionHandler)completion;

/////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - class methods
/**
 * 在手機上顯示廣告頁
 * @param promotionURL 廣告頁的連結
 * @param viewController 要從哪一個頁面顯示出來
 * @param licence app license
 * @param style 廣告頁的樣式
 * @param openLinkOutOfApp 是否將廣告頁的連結在app中開啟
 * @param completion 廣告頁完成的通襠
 */
+ (void)showPromotionURL:(NSURL *)promotionURL
      fromViewController:(UIViewController*)viewController
             withLicence:(NSString*)licence
          promotionStyle:(PromotionStyle)style
        openLinkOutOfApp:(BOOL)openLinkOutOfApp
              completion:(PromotionCompletionHandler)completion;

+ (void)showPromotionFromViewController:(UIViewController*)viewController
                            withLicence:(NSString*)licence
                         promotionStyle:(PromotionStyle)style
                       openLinkOutOfApp:(BOOL)openLinkOutOfApp
                             completion:(PromotionCompletionHandler)completion;

+ (void)showPromotionFromViewController:(UIViewController*)viewController
                            withLicence:(NSString*)licence
                         promotionStyle:(PromotionStyle)style
                             completion:(PromotionCompletionHandler)completion;

+ (void)showiPadPromotionURL:(NSURL *)promotionURL
          fromViewController:(UIViewController *)aViewController
                 withLicence:(NSString*)licence
                       style:(PromotionStyle)aStyle
                  viewBounds:(CGRect)viewBounds
            openLinkOutOfApp:(BOOL)openLinkOutOfApp
                  completion:(PromotionCompletionHandler)aCompletionHandler;

+ (void)showiPadPromotionFromViewController:(UIViewController *)aViewController
                                withLicence:(NSString*)licence
                                      style:(PromotionStyle)aStyle
                                 viewBounds:(CGRect)viewBounds
                           openLinkOutOfApp:(BOOL)openLinkOutOfApp
                                 completion:(PromotionCompletionHandler)aCompletionHandler;

+ (void)showiPadPromotionFromViewController:(UIViewController *)aViewController
                                withLicence:(NSString*)licence
                                      style:(PromotionStyle)aStyle
                                 viewBounds:(CGRect)viewBounds
                                 completion:(PromotionCompletionHandler)aCompletionHandler;
@end
