//
//  PPPatternOCRController.h
//  CameraTest
//
//  Created by cheng sanhue on 12/7/3.
//  Copyright (c) 2012年 Penpower Technology LTD. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "PPQuadrilateralModel.h"

typedef NS_ENUM(NSInteger, CaptureState)
{
    CaptureState_Error=-1,
    CaptureState_Nothing=0,
    CaptureState_ReadyToCapture,        // 偵測到第一張pattern ，提示放上名片
    CaptureState_CaptureNow,            // 已穩定，可以拍照
    CaptureState_NoPatternAlarm,   // 10次沒有偵測到pattern，提示APP做處理
};

@interface PPPatternOCRController : NSObject

@property (nonatomic, assign) BOOL forLinkVersion;              // WorldCardLink的版本有些流程不同， default NO
@property (nonatomic, assign) CaptureState currentState;		// 最後的狀態，不包含CaptureState_Nothing

+ (PPPatternOCRController*)sharedPatternOCRController;

/**
 * 取得此影像的Pattern狀態
 * @param image 用來判斷pattern 的影像
 * @return CaptureState
 */
+ (CaptureState)captureStateWithImage:(UIImage*)image;

// 使用後必須使用此API釋放核心
+ (void)releasePatternOCRControler;

/**
 * 回傳QRCode在畫面上的對焦點
 * 請在CaptureState為CaptureState_ReadyToCapture時才取得，如果是CGPointZero表示沒有偵測到
 * @return CGPoint QRCode所在的對焦點
 */
+ (CGPoint)focusPointForQRCodePosition;

/**
 * 透過核心HoughTrans_Color_LinkQR取得名片裁切範圍  
 * @param image 要被裁切的圖
 * @return PPQuadrilateralModel
 */
+ (PPQuadrilateralModel *)houghTransLinkQRformQuadrilateralModelForImage:(UIImage *)image;

/**
 * 透過核心HoughTrans_Color_Link取得名片裁切範圍
 * @param image 要被裁切的圖
 * @return PPQuadrilateralModel
 */
+ (PPQuadrilateralModel *)houghTransLinkformQuadrilateralModelForImage:(UIImage *)image;

@end
