//
//  PPLocationController+ParameterDefine.h
//
//
//  Created by Howard on 2015/12/30.
//
//

#ifndef PPLocationController_ParameterDefine_h
#define PPLocationController_ParameterDefine_h

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - OperationQueue Related

static const NSUInteger PPLocationControllerDefaultConcurrencyOperationCount = 1;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notification Name Define

typedef NS_OPTIONS(NSInteger, PPLocationControllerAccessResult)
{
    PPLocationControllerAccessResult_None = 0,
    PPLocationControllerAccessResult_GetCurrentLocationSuccess,
    PPLocationControllerAccessResult_GetCurrentLocationFailure,
    PPLocationControllerAccessResult_GetAddressLocationSuccess,
    PPLocationControllerAccessResult_GetAddressLocationFailure,
    PPLocationControllerAccessResult_GetAddressLocationEnd,
    PPLocationControllerAccessResult_GetAddressStringSuccess,
    PPLocationControllerAccessResult_GetAddressStringFailure,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Error Code Define

typedef NS_OPTIONS(NSInteger, PPLocationControllerErrorCode)
{
    PPLocationControllerErrorCode_Other = -1000,
    PPLocationControllerErrorCode_RequestTimeOut = -1001,
    PPLocationControllerErrorCode_NetworkDisconnected = -1002,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notificatoin Name Define

static NSString * const PPLocationControllerNotification = @"PPLocationControllerNotification";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notification UserInfo Key 

//結果
static NSString * const PPLocationControllerUserInfoKey_AccessResult = @"PPLocationControllerUserInfoKey_AccessResult";

//識別符號
static NSString * const PPLocationControllerUserInfoKey_Identity = @"PPLocationControllerUserInfoKey_Identity";

//Location位置結果
static NSString * const PPLocationControllerUserInfoKey_Location = @"PPLocationControllerUserInfoKey_Location";

//地址Location位置結果 The array of CLPlacemark 
static NSString * const PPLocationControllerUserInfoKey_Placemarks = @"PPLocationControllerUserInfoKey_Placemarks";

//地址字串結果 The array of XML Address Structure
static NSString * const PPLocationControllerUserInfoKey_AddressDictionary = @"PPLocationControllerUserInfoKey_AddressDictionary";

//錯誤
static NSString * const PPLocationControllerUserInfoKey_Error = @"PPLocationControllerUserInfoKey_Error";

//來源地址
static NSString * const PPLocationControllerUserInfoKey_Address = @"PPLocationControllerUserInfoKey_Address";

//方法 PPLocationControllerUserInfoKey_Method:NSStringFromClass([self class]),
static NSString * const PPLocationControllerUserInfoKey_Method = @"PPLocationControllerUserInfoKey_Method";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Operation Releated Method

static CGFloat const PPLocationController_OperationTimeInterval = 1;
static CGFloat const PPLocationController_OperationTimeOutInterval = 3;

#endif /* PPLocationController_ParameterDefine_h */
